(function($){

BEM.DOM.decl({name : 'b-prices-constructor-context-scope', baseBlock : 'b-prices-constructor-control' }, {
    onSetMod: {
        'js': function(){
            this.bindTo('select', 'change', this.onSelectChange);
            this.__base();

        }
    },



    bindModelEvents: function(model, isBind) {
        var method = isBind ? 'onField' : 'unField';

        model[method]('context_scope', 'change', this.onContextScopeChanged, this);
        model[method]('context_toggle', 'change', this.onToggleChanged, this);

        return this;

    },

    getDisabled: function() {
        return !this.model.get('context_toggle') || this.__base();
    },

    onToggleChanged: function() {
        this.elem('select').prop('disabled', this.getDisabled());

        return this;
    },

    onSelectChange: function() {
        var data = {};

        data['context_scope'] = this.elem('select').val();
        this.model.update(data, this);

        return this;
    },

    onContextScopeChanged: function(e) {
        if (e.source == this) { return; }
        var scope = this.model.get('context_scope');
        //Если нет возможности выбрать fixed, но оно было выбрано ранее
        if (!this.elem('select').find('option[value="' + scope + '"]').length && scope == 'fixed') {
            scope = '100';
            this.model.set('context_scope', scope, this);
        }
        this.elem('select').val(scope);

        return this;
    },

    reset: function() {
        return this
            .onContextScopeChanged({})
            .onToggleChanged()
            .__base();

    }
});

})(jQuery);



