(function($){

BEM.DOM.decl('b-prices-constructor-control', {
    onSetMod: {
        'js': function(){
            var constructor = BEM.blocks['b-prices-constructor'], cid,
                path = this.params.cid || constructor.getCampaignId() ? 'campaign:' + (this.params.cid ||
                    constructor.getCampaignId()) : 'campaign';

            this.model = BEM.blocks['i-models-manager'].get(path, 'b-prices-constructor');
            this.onChangeCid({}, {
                newCid: constructor.getCampaignId() || cid
            });
        }
    },

    reset: function() {
        this.campModel &&
            this.campModel.get('currency') &&
            this.elem('currency').text(get_currency(this.campModel.get('currency') || window.campCurrency).name);

        return this;
    },

    getDisabled: function() {
        return this.campModel.get('nobsdata');
    },

    onChangeCid: function(e, data) {
        var newCid = data.newCid,
            oldCid = data.oldCid,
            constructor = BEM.blocks['b-prices-constructor'];
        oldCid && this.bindModelEvents(constructor.getModel(oldCid), 0);
        oldCid && this.bindCampModelEvents(constructor.getCampaignModel(oldCid), 0);
        this.model = constructor.getModel(newCid);
        this.campModel = constructor.getCampaignModel(newCid);
        this.reset();

        this.bindModelEvents(this.model, 1);
        this.bindCampModelEvents(this.campModel, 1);

    },

    bindCampModelEvents: function(model, isBind)  {
        //implemented in subclasses
    },

    bindModelEvents: function(model, isBind) {
        //implemented in subclasses
    }
});

})(jQuery);
