
include("../b-prices-constructor/validator/b-prices-constructor__validator.js");


(function($){

    var validator = Lego.block['b-prices-constructor__validator'],
        iModelManager = BEM.blocks['i-models-manager'];

    BEM.DOM.decl({name : 'b-prices-constructor-inline'}, {
        onSetMod: {
            'js': function(){
                this.model = iModelManager.get('campaign', 'b-prices-constructor');
                this.campModel = iModelManager.get('campaign', 'b-campaign-view');

                BEM.blocks['b-prices-constructor'].setCampaignId('');

                this.isPmaxHidden = !this.campModel.get('show_pmax');
                this.platformSelect = this.campModel.get('platform_select');


                this
                    .bindTo('save', 'click', this.save)
                    .bindTo('close', 'click', this.close);

                this.model
                    .onField('collapsed', 'change', this.onCollapsedChanged, this)
                    .onField('platform', 'change',function() {
                        this.setMod('platform', this.model.get('platform'))
                    } ,this);


                this.campModel.onFirst('b-phrases-list-models:init', function(){
                    var disabled = this.campModel.get('nobsdata');
                    $.each(this.elem('save'), function(i, elem) {
                        $(elem).prop('disabled', disabled)
                    });
                    this.init();
                }, this);

                this.campModel.onField('places_strategy', 'change', function(e, data) {
                    if (data.source == this) { return; }

                    var placesStrategy = this.campModel.get('search_strategy') != 'stop' ? this.campModel.get('places_strategy') : 'context';
                    this.setMod('places-strategy', placesStrategy)
                }, this);


            }
        },

        init: function() {
            var value,
                viewMode = this.getMod('view-mode'),
                minPay = get_currency(this.campModel.get('currency')).MIN_PAY;

            try {
                value = JSON.parse( direct.CampOptions.get('price_editor') || '{}' );
            } catch(e) { };
            if (viewMode !== 'both') {
                value.context_toggle = value.search_toggle = 1;
            }
            this.setValue($.extend({}, this.model.getModelStartValue(), { price_search: minPay, price_context: minPay }, value));

            this.model.update({
                view_mode: viewMode
            });

            if (this.campModel.get('strategy') == 'different_places') {
                if (viewMode != 'both') {
                    var places_strategy = this.campModel.get('search_strategy') == 'stop'? 'context' : this.campModel.get('places_strategy') || 'search';
                    this.model.update({'places_strategy': places_strategy}, this)
                }
            }
        },

        save: function() {
            var value = this.getValue();

            if (!this.validate(value)) return;
            this.updatePrices(value);
            if (!this.model.get('collapsed')) this.close();
        },

        close: function() {
            this.model.update({'collapsed': 1}, this);
            this.setCollapsed(1);
        },

        updatePrices: function(value) {
            var controller =  BEM.blocks['b-prices-constructor-inline'];

            direct.CampOptions.set('price_editor', $.stringify(value), function() {});
            if (this.campModel.get('strategy') == 'different_places') {
                if (this.isSearchPlace()) {
                    controller.updateSearchPrices(value);
                }
                if (this.isContextPlace()) {
                    controller.updateContextPrices(value, this.campModel);
                }
            } else {
                // updateSearchPrices или updateContextPrices
                controller['update' + (value.platform == 'search' ? 'Search' : 'Context') + 'Prices'](value, this.campModel);
            }
        },

        //для старого формата данных, который ещё может сохранитья на сервере
        backwardCompatibility: function(value) {
            if (value.platform == 'network') {
                value.platform = 'context';
            }
            value.phrases = value.phrases || value.search_phrases;
            value.context_scope = value.context_scope || value.network_scope;
            value.proc_base = value.proc_base ?  value.proc_base : value.search_proc_diff ? 'diff' : 'value';
            value.proc = value.proc || value.search_proc;

            return value;
        },

        setValue: function(value) {
            var minPay = get_currency(this.campModel.get('currency')).MIN_PAY;

            value = this.backwardCompatibility(value);
            // DIRECT-9327
            if(value.platform == 'context' && value.price != minPay && this.platformSelect == 0) {
                value.price = minPay;
            }
            //DIRECT-13771
            if(this.platformSelect == 0) {
                value.platform = 'search';
            }
            // DIRECT-9327
            if (value.price_base == 'pmax' && this.isPmaxHidden && value.price != minPay) {
                value.price_base = 'pmin';
            }

            this.model.update(value, this);

        },

        getValue: function() {
            var result = this.model.memento(true);

            $.extend(result,
                result.collapsed ?
                    {
                        phrases: true,
                        phrases_search: true,
                        proc: 0,
                        proc_search: 0,
                        proc_context: 0
                    } :
                    {},
                {
                    collapsed: 1,
                    price_context: result.price_context,
                    price_search: result.price_search
                });

            return result;
        },

        setCollapsed: function(collapsed) {
            this.setMod('expanded', collapsed ? 'no' : 'yes');
        },

        onCollapsedChanged: function(e) {
            if (e.source == this) return;
            this.setCollapsed(this.model.get('collapsed'));
        },

        //только для стратегии different_places
        isSearchPlace: function() {
            return this.getMod('strategy') == 'both' && this.model.get('search_toggle')
                || this.campModel.get('places_strategy') == 'search';
        },

        isContextPlace: function() {
            return  this.getMod('strategy') == 'both' && this.model.get('context_toggle') ||
                this.campModel.get('places_strategy') == 'context' ||
                this.campModel.get('search_strategy') == 'stop';
        },

        validate: function(value) {
            return validator.api.validate(value, {
                isSimple: this.model.get('collapsed'),
                strategy: this.campModel.get('strategy')
            }, this.isContextPlace(), this.isSearchPlace());

        }
    }, {
        updateSearchPrices: function(value) {
            // Форма с установками
            var price_base = value['price_base_search'],
                proc = value['proc_search'],
                proc_base = value['proc_base_search'],
                price_max = value['price_search'],
                updatePhrases = 1,
                modelsPath = 'campaign&banner:*&phrase:*',
                modelsName = 'b-phrases-list-phrase',
                _this = this,
                updateData = {};

            iModelManager.eachModel(function(id, model) {
                //фразы, помеченные как удалённые не трогаем
                if (model.get('deleted')) { return true; }


                var calc_price = round_price_to_currency_step(
                    _this.calcAutoPrice(
                        price_base,
                        proc,
                        proc_base,
                        price_max,
                        model.get('guarantee'),
                        model.get('premium')
                    ),
                    iModelManager.get('campaign', 'b-campaign-view').get('currency'),
                    'up');

                if (calc_price) {
                    updateData[model.get('bannerId')] = updateData[model.get('bannerId')] || {};
                    updateData[model.get('bannerId')][model.path()] = function() {
                        model.update({'price': calc_price}, _this);
                    }
                }
            }, modelsPath, modelsName);
            $.each(updateData, function(bid, data) {
                iModelManager.get('campaign&banner:' + bid, 'b-banners-list-banner')
                    .trigger('constructor-update', data)
            });

        },

        calcAutoPrice: function(price_base, proc, proc_base, price_max, guarantee, premium)
        {
            // Определяем цену и разницу до следующей цены
            var price,
                diff,
                minval = guarantee[3].bid_price / 1e6,
                maxval = guarantee[0].bid_price / 1e6,
                pmin = premium[2].bid_price / 1e6,
                pmax = premium[0].bid_price / 1e6,
                pmax2 = premium[1].bid_price / 1e6;

            if (price_base == 'pmin') {
                price = pmin;
                diff = pmax2 - pmin;
            } else if (price_base == 'pmax') {
                price = pmax;
                diff = 0;
            } else if (price_base == 'pmax2') {
                price = pmax2;
                diff = pmax - pmax2;
            } else if (price_base == 'max') {
                price = maxval;
                diff = pmin - maxval;
            } else if (price_base == 'min') {
                price = minval;
                diff = maxval - minval;
            }

            if (diff < 0) diff = 0;
            // Прибавляем проценты
            price += (proc_base == 'value' ? price : diff) * proc / 100;
            // Округляем
//            price = Math.round(price * 100) / 100;
            // Сравниваем с саксимальной ценой
            if (price > price_max) price = price_max;

            return (price + '').replace(/(\.[0-9])$/, '$10');
        },

        updateContextPrices: function(value, campModel) {

            var strategy = campModel.get('strategy'),
                minPrice = get_currency(campModel.get('currency')).MIN_PRICE,
                scope = value['context_scope'],
                price = value['price_context'],
                proc = value['proc_context'],
                updatePhrases = value['phrases_context'],
                updateRetargetings = value['retargetings_context'],
                modelsPath = 'campaign&banner:*&phrase:*,campaign&banner:*&retargeting:*',
                modelsName = 'b-phrases-list-phrase',
                updateData = {},
                _this = this;

            iModelManager.eachModel(function(id, model) {
                //фразы, помеченные как удалённые не трогаем
                if (model.get('deleted')) { return true; }
                if (!updatePhrases && !model.get('is_retargeting') ||
                    !updateRetargetings && model.get('is_retargeting')) {  return true; }

                var pval = model.get('probs'),
                    probs = [],
                    prices = [];

                if (strategy != 'different_places' && model.get('mode') == 'active' &&  !model.get('is_retargeting')) {  return;  }

                $.each(pval.split(';'), function() {
                    var tmp = this.split(',');
                    prices.push(+tmp[0]);
                    probs.push(+tmp[1]);
                });

                var calc_price =
                    scope == 'fixed' ?
                        price :
                        model.get('is_retargeting') ?
                            minPrice :
                            direct.autobroker.calcContextPriceByCoverage(scope, model.get('pokazometer_data')) / 1e6 ;

                if (calc_price) {
                    if (proc) {
                        // Прибавляем проценты
                        calc_price *= 1 + proc / 100;
                    }
                    calc_price = round_price_to_currency_step(calc_price, campModel.get('currency'), 'up');
                    calc_price = Math.min(price, calc_price);
                } else {
                    calc_price = minPrice;
                }

                if (calc_price) {
                    var bid = model.get('bannerId');

                    updateData[ bid] = updateData[bid] || {};
                    updateData[bid][model.path()] = function() {
                        model.update({'price_context': calc_price}, _this);
                    }
                }
            }, modelsPath, modelsName);

            $.each(updateData, function(bid, data) {
                iModelManager.get('campaign&banner:' + bid, 'b-banners-list-banner')
                    .trigger('constructor-update', data)
            });

        }
    });

})(jQuery);
