(function($){

BEM.DOM.decl({name : 'b-prices-constructor-phrase-type', baseBlock : 'b-prices-constructor-control' }, {
    onSetMod: {
        'js': function(){
            var _this = this;
            _this.platform = this.params.platform;
            _this.name1 = this.params.name1;
            _this.name2 = this.params.name2;
            _this.bindTo('cbx', 'click', this.onCbxClick);
            _this.__base();
        }
    },

    bindModelEvents: function(model, isBind) {
        isBind ?
            model
                .onField(this.platform + '_toggle', 'change', this.setDisabled, this)
                .onField(this.name1, 'change', {type: this.name1}, this.onExternalChange, this)
                .onField(this.name2, 'change', {type: this.name2}, this.onExternalChange, this) :
            model
                .unField(this.platform + '_toggle', 'change', this.setDisabled, this)
                .unField(this.name1, 'change', this.onExternalChange, this)
                .unField(this.name2, 'change', this.onExternalChange, this);

    },

    reset: function(e) {
        this.onExternalChange({data: {type: this.name1}});
        this.onExternalChange({data: {type: this.name2}});
        this.setDisabled();
        this.__base();
    },

    getDisabled: function() {
        return !this.model.get(this.platform + '_toggle') || this.__base();
    },

    setDisabled: function() {
        var disabled = this.getDisabled();
        $.each(this.elem('cbx'), function(i, elem) {
            $(elem).prop('disabled', disabled);
        })
    },


    onCbxClick: function(e) {
        var elem = $(e.data.domElem),
            type = this.getMod(elem, 'type').replace(/-/g, "_");

        var data = {};
        data[type] = +elem.prop('checked');
        if (!this.elem('cbx', 'type', this.name1.replace('_', '-')).prop('checked')
            && !this.elem('cbx', 'type', this.name2.replace('_', '-')).prop('checked')) {

            var nextType = type == this.name1 ? this.name2 : this.name1;
            data[nextType] = 1;
            this.elem('cbx', 'type', nextType.replace('_', '-')).prop('checked', true);
        }
        this.model.update(data, this)
    },

    onExternalChange: function(e, data) {
        if (data && data.source == this) { return; }
        var type = e.data.type;

        this.elem('cbx', 'type', type.replace('_', '-')).prop('checked', !!this.model.get(type));

    }
});

})(jQuery);


