/*
 * Чекбоксы поиск/контекст для отдельного размещения
 */
(function($){

BEM.DOM.decl({name : 'b-prices-constructor-platform-toggle', baseBlock : 'b-prices-constructor-control' }, {
    onSetMod: {
        'js': function(){
            this.bindTo('checkbox', 'change', this.onCheckboxClick);
            this.__base();
        }
    },

    bindModelEvents: function(model, isBind) {
        model[isBind ? 'onField' : 'unField'](this.params.platform + '_toggle', 'change', this.onCheckboxChanged, this);
    },

    reset: function() {
        this.onCheckboxChanged({}, {});
        this.__base();
    },

    onCheckboxClick: function() {
        var checked = !!this.elem('checkbox').prop('checked');
        this.model.set(this.params.platform + '_toggle', checked, this)
    },

    onCheckboxChanged: function(e, data) {
        if (data.source == this) { return; }
        this.elem('checkbox').prop('checked', this.model.get(this.params.platform + '_toggle') ? true : false)
    }
});

})(jQuery);
