/*
 * Переключатель для активных на поиске/на тематических площадках
 */

(function($){
    BEM.DOM.decl({name : 'b-prices-constructor-platform', baseBlock : 'b-prices-constructor-control' }, {
        onSetMod: {
            'js': function(){
                this.bindTo('change', function() {
                    this.model.update({platform: this.domElem.val()}, this);
                });



                this.__base();

            }
        },

        bindModelEvents: function(model, isBind) {
            model[isBind ? 'onField' : 'unField']('platform', 'change', this.onPlatformChanged, this);
        },

        reset: function() {
            this.onPlatformChanged({});
            this.__base();
        },

        onPlatformChanged: function(e) {
            if (e.source == this) { return; }
            var platform = this.model.get('platform');
            //DIRECT-19891
            if (platform == 'both' && !this.domElem.find('option[value="both"]').length && this) {
                platform = 'search';
            }
            this.domElem.val(platform)
        }
    });

})(jQuery);
