(function($){
    var facadeSearch = [
        ['tab_simple', 'is_simple'],
        ['search_price_base', 'price_base_search'],
        ['search_proc', 'proc_search'],
        ['search_proc_base', 'proc_base_search'],
        ['search_max_price', 'price_search'],
        ['wizard_search', 'search_toggle'],
        ['single_price', 'price_search']
    ],
    facadeContext = [
        ['tab_simple', 'is_simple'],
        ['search_proc_ctx', 'proc_context'],
        ['wizard_ctx_retargetings', 'retargetings_context'],
        ['wizard_ctx_phrases', 'phrases_context'],
        ['wizard_ctx', 'context_toggle'],
        ['ctx_scope', 'context_scope'],
        ['ctx_proc', 'proc_context'],
        ['ctx_max_price', 'price_context'],
        ['single_price_ctx', 'price_context']
    ],
    facadeSimple = [
        ['tab_simple', 'is_simple'],
        ['wizard_search_price_base', 'price_base_search'],
        ['wizard_search_proc', 'proc_search'],
        ['search_proc_base', 'proc_base_search'],

        ['wizard_context_phrases', 'phrases_context'],
        ['wizard_context_retargetings', 'retargetings_context'],
        ['wizard_search_max_price', 'price_search'],
        ['wizard_network_max_price', 'price_context'],
        ['wizard_network_scope', 'context_scope'],
        ['simple_platform', 'platform'],
        ['wizard_platform', 'platform']
    ];


    BEM.DOM.decl({name : 'b-prices-constructor-popup'}, {
        onSetMod: {
            'js': function(){
                this.validator = Lego.block['b-prices-constructor__validator'];

                this.setMod('success', 'no');
                this.setMod('nobs', 'no');
                this.setMod('places-strategy', 'none');
                this.setMod('platform', 'search');

                this.tabbedPane = this.findBlockInside('b-tabbed-pane').on('current', function(e, data) {
                    var tab = this.getMod(data.current, 'mode');
                    this.model.set('is_simple', tab == 'simple' ? 1 : 0);
                    this.setMod('tab', tab)
                }, this);

                this.bindTo('save', 'click', this.save);

                this.bindTo('close', 'click', this.close);


                var constructor = BEM.blocks['b-prices-constructor'], cid,
                    path = this.params.cid ? 'campaign:'+this.params.cid : 'campaign';

                this.model = BEM.blocks['i-models-manager'].get(path, 'b-prices-constructor');

                constructor.on('change-cid', this.onChangeCid, this);

                if (cid = constructor.getCampaignId()) {
                    this.onChangeCid({}, {
                        newCid: cid
                    });
                } else {
                    this.reset();
                    this.bindModelEvents(this.model, 1);
                }
            }
        },

        facadeToServer: function(value, full) {
            var result = {};
            if (this.campModel.get('strategy') == 'different_places') {
                (full || value.search_toggle) && $.each(facadeSearch, function(i, arr) {
                    if (value && value[arr[1]] !== undefined) {
                        result[arr[0]] = value[arr[1]]
                    }
                });
                (full || value.context_toggle) && $.each(facadeContext, function(i, arr) {
                    if (value && value[arr[1]] !== undefined) {
                        result[arr[0]] = value[arr[1]]
                    }
                });
                if (this.campModel.get('search_strategy') == 'stop') {
                    result.wizard_search = 0;
                }
            } else {
                if (value.platform == 'context') {
                    value.platform = 'network';
                }
                $.each(facadeSimple, function(i, arr) {
                    if (value && value[arr[1]] !== undefined) {
                        result[arr[0]] = value[arr[1]]
                    }
                });
                result.simple_price =   value.platform == 'network' ? value.price_context : value.price_search;
            }
            if (!result.tab_simple && result.wizard_platform == 'both') result.wizard_platform = 'search';
            return result;
        },

        validate: function(value) {
            return this.validator.api.validate(value, {
                isSimple: this.model.get('is_simple'),
                strategy: this.campModel.get('strategy'),
                currency: this.campModel.get('currency')
            }, this.isContextPlace(), this.isSearchPlace());
        },

        isContextPlace: function() {
            return this.model.get('context_toggle');
        },

        isSearchPlace: function() {
            return this.model.get('search_toggle');

        },

        saveAjax: function(value) {
            value = $.extend({}, value, { cmd: 'setAutoPriceAjax', cid: BEM.blocks['b-prices-constructor'].getCampaignId() });

            var _this = this;

            $.ajax({
                type: 'POST',
                dataType: 'json',
                url: '/registered/main.pl',
                data: value,
                success: function(result) {
                    if (result.success) {
                        _this.setMod('success', 'yes');
                    } else {
                        alert(result.error);
                        _this.elem('save').prop('disabled', false);
                    }
                },
                complete: function(xhr, status) {
                    if (status != 'success') alert(iget('Не получается выполнить запрос. Проверьте подключение к интернету'));
                }
            });
        },

        save: function() {
            var value = this.model.memento(true);

            if (!this.validate(value)) return;

            if (this.campModel.get('nobsdata')) {
                this.setMod('nobs', 'yes');
                return;
            }

            BEM.blocks['b-prices-constructor'].setValueFunction(this.facadeToServer(value, true));

            this.elem('save').prop('disabled', true);
            this.saveAjax(this.facadeToServer(value, false));
        },

        close: function() {
            BEM.blocks['b-prices-constructor'].closeFunction();
        },

        facadeFromServer: function(value) {
            var result = {};
            value = value || {};
            if (this.campModel.get('strategy') == 'different_places') {
                if (value) {
                    if (this.campModel.get('search_strategy') != 'stop') {
                        $.each(facadeSearch, function(i, arr) {
                            if (value && value[arr[0]] !== undefined) {
                                result[arr[1]] = value[arr[0]]
                            }
                        });
                    } else {
                        result.search_toggle = 0;
                    }
                    $.each(facadeContext, function(i, arr) {
                        if (value && value[arr[0]] !== undefined) {
                            result[arr[1]] = value[arr[0]]
                        }
                    });
                }
            } else {
                $.each(facadeSimple, function(i, arr) {
                    if (value && value[arr[0]] !== undefined) {
                        result[arr[1]] = value[arr[0]]
                    }
                });
                if (result.platform == 'network') {
                    result.platform = 'context';
                }
                if (result.platform == 'context') {
                    result.price_context = value.simple_price;
                } else {
                    result.price_search = value.simple_price;
                }
            }
            return result;
        },

        bindCampModelEvents: function(campModel, isBind) {
            var method = isBind ? 'onField' : 'unField';
            campModel
                [method]('places_strategy', 'change', function(e, data) {
                    if (data.source == this) { return; }

                    var placesStrategy = this.campModel.get('search_strategy') != 'stop' ? this.campModel.get('places_strategy') : 'context';
                    this.setMod('platform', placesStrategy)
                }, this);
        },

        bindModelEvents: function(model, isBind) {
            var method = isBind ? 'onField' : 'unField';
            model
                [method]('platform', 'change',function() {
                    this.setMod('platform', this.model.get('platform'))
                }, this)
                [method]('search_toggle context_toggle', 'change', this.onToggleChanged, this)
        },

        onToggleChanged: function() {
            if (this.campModel.get('strategy') == 'different_places' ) {
                this.elem('save').prop('disabled', !this.model.get('search_toggle') && !this.model.get('context_toggle'));
            }
        },

        onChangeCid: function(e, data) {
            var newCid = data.newCid,
                oldCid = data.oldCid,
                constructor = BEM.blocks['b-prices-constructor'];
            oldCid && this.bindModelEvents(constructor.getModel(oldCid), 0);
            oldCid && this.bindCampModelEvents(constructor.getCampaignModel(oldCid), 0);
            this.model = constructor.getModel(newCid);
            this.campModel = constructor.getCampaignModel(newCid);
            this.reset(data);

            this.bindModelEvents(this.model, 1);
            this.bindCampModelEvents(this.campModel, 1);

        },

        reset: function(data) {
            if (!this.campModel) { return; }

            var _this = this,
                isDiffPlace = this.campModel.get('strategy') == 'different_places',
                isStop = this.campModel.get('search_strategy') == 'stop',
                minPay = get_currency(this.campModel.get('currency')).MIN_PAY;

            _this.elem('save').prop('disabled', true);


            BEM.blocks['b-prices-constructor'].getValueFunction(function(value) {

                value = $.extend(
                    {},
                    _this.model.getModelStartValue(),
                    { price_search: minPay, price_context: minPay },
                    _this.facadeFromServer(value) || {});

                if (isDiffPlace && isStop) {
                    value.search_toggle = 0;
                    value.context_toggle = 1;
                } else if (isDiffPlace && !value.search_toggle && !value.context_toggle) {
                    value.context_toggle = 1;
                    value.search_toggle = 1;
                }

                if (!isDiffPlace) {
                    value.context_toggle = 1;
                    value.searcht_toggle = 1;
                }
                _this.model.initData(value, this);

                BEM.blocks['b-prices-constructor'].trigger('change-cid-end', data);
                _this.elem('save').prop('disabled', false);

                _this.tabbedPane.selectByIndex(_this.model.get('is_simple') ? 0 : 1);

                _this.setMod('tab', _this.model.get('is_simple') ? 'simple' : 'wizard');
                _this.setMod('view_mode', isDiffPlace && !isStop ? 'both' : 'single');
                _this.setMod('platform', _this.model.get('platform') || 'search');

            });

            this.setMod('success', 'no');
            this.setMod('nobs', 'no');
            this.setMod('strategy', isDiffPlace ? 'diff-place' : 'simple');
            this.setMod('places-strategy', !isStop ? 'both' : 'context');
            this.setMod('has-platform', 'yes');
            this.elem('title').html(this.campModel.get('name') || iget('Цена клика для всей кампании'));
            this.__base();

        }
    });

})(jQuery);
