(function($){

BEM.DOM.decl({name : 'b-prices-constructor-price-base', baseBlock : 'b-prices-constructor-control' }, {
    onSetMod: {
        'js': function(){
            this.bindTo('select', 'change', this.onSelectChange);
            this.__base();
        }
    },

    bindModelEvents: function(model, isBind) {
        var method = isBind ? 'onField' : 'unField';
        model
            [method]('price_base_search', 'change', this.onPriceBaseChanged, this)
            [method]('search_toggle', 'change', this.setDisabled, this)
    },


    reset: function() {
        this.onPriceBaseChanged({});
        this.onSelectChange();
        this.setDisabled();
        this.__base();
    },

    getDisabled: function() {
        return !this.model.get('search_toggle') || this.__base();
    },

    setDisabled: function() {
        var disabled =  this.getDisabled();
        this.elem('select').prop('disabled', disabled);
    },

    onSelectChange: function() {
        var data = {};
        data['price_base_search'] = this.elem('select').val();
        this.model.update(data, this);
    },

    onPriceBaseChanged: function(e) {
        if (e.source == this) { return; }
        this.elem('select').val(this.model.get('price_base_search'))
    }
});

})(jQuery);
