(function($){

BEM.DOM.decl({name : 'b-prices-constructor-price', baseBlock : 'b-prices-constructor-control' }, {
    onSetMod: {
        'js': function(){
            this.isPopup = this.params.isPopup;
            this.platform = this.params.platform;
            this.suffix = '_' + this.platform;

            this.bindTo('input', 'change', this.onInputChange);
            this.__base();

        }
    },

    bindModelEvents: function(model, isBind) {
        var method = isBind ? 'onField' : 'unField';

        model
            [method](this.platform + '_toggle', 'change', this.setDisabled, this)
            [method]('price' + this.suffix, 'change', this.onPriceChanged,this)
            [method]('platform', 'change', this.onContextScopeChanged, this)
            [method]('context_scope', 'change',  this.onContextScopeChanged, this);
    },

    reset: function() {
        this.onPriceChanged();
        this.setDisabled();
        this.onContextScopeChanged();
        this.__base();
    },

    onPriceChanged: function() {
        this.elem('input').val(this.model.view('price' + this.suffix));
    },

    onContextScopeChanged: function() {
        this.setMod('fixed', this.platform == 'context' && !this.isPopup && this.model.get('context_scope') == 'fixed' ? 'yes' : 'no');
    },

    onInputChange: function() {
        var data = {},
            number = common.number;

        data['price' + this.suffix] = this.elem('input').val();

        this.model.update(data, this)
    },

    getDisabled: function() {
        return this.platform != 'common' && !this.model.get(this.platform + '_toggle') || this.__base();
    },

    setDisabled: function() {
        var disabled =  this.getDisabled();

        this.elem('input').prop('disabled', disabled);
    }
});

})(jQuery);
