(function($){

BEM.DOM.decl({name : 'b-prices-constructor-proc', baseBlock : 'b-prices-constructor-control' }, {
    onSetMod: {
        'js': function(){
            this.bindTo('input', 'change', this.onInputChange);

            if (this.elem('radio').length) {
                this.bindTo('radio', 'click', this.onRadioClick);
            }

            this.platform = this.params.platform;
            this.__base();
        }
    },

    bindModelEvents: function(model, isBind) {
        var method = isBind ? 'onField' : 'unField';

        if (this.platform == 'search') {
            model
                [method]('proc_base_search', 'change', this.onRadioChanged, this)
                [method]('price_base_search', 'change', this.onPriceBaseChanged, this)

        }
        model
            [method]('proc_' + this.platform, 'change', this.onProcChanged, this)
            [method](this.platform + '_toggle', 'change', this.setDisabled, this)

    },



    reset: function() {
        this.onRadioChanged({});
        this.onProcChanged({});
        this.onPriceBaseChanged({});
        this.setDisabled();
        this.__base();
    },

    getDisabled: function() {
        return !this.model.get(this.platform + '_toggle') || this.__base();
    },

    setDisabled: function() {
        var isPmax = this.model.get('price_base_search') == 'pmax',
            disabled = this.getDisabled();

        this.elem('input').prop('disabled', disabled);

        if (!this.elem('radio').length) { return; }

        this.elem('radio', 'mode', 'price')
            .add(this.elem('radio', 'mode', 'diff'))
            .prop('disabled', disabled || isPmax);
    },

    onRadioClick: function(e) {
        var data = {};
        data['proc_base_search'] = this.elem('radio', 'mode', 'price').prop('checked') ? 'value' : 'diff';
        this.model.update(data, this);
    },

    onRadioChanged: function(e, data) {
        if (data && data.source == this || !this.elem('radio').length) {  return; }

        var procBase = this.model.get('proc_base_search');

        this.elem('radio', 'mode', 'price').prop('checked', procBase == 'value');
        this.elem('radio', 'mode', 'diff').prop('checked', procBase == 'diff');
    },

    onInputChange: function(e) {
        var data = {};
        data['proc_' + this.platform] = this.elem('input').val();
        this.model.update(data, this);
    },

    onProcChanged: function(e) {
        this.elem('input').val(this.model.get('proc_' + this.platform));
    },

    onPriceBaseChanged: function(e) {
        if (!this.elem('radio').length)  { return; }
        var value = this.model.get('price_base_search'),
            isPmax = value == 'pmax',
            valueTexts = {
                min: iget('разницы до 1-го места'),
                max: iget('разницы до спецразмещения'),
                pmin: window.showVCGAuction ?
                    iget('разницы до 2-го спецразмещения') :
                    iget('разницы до 1-го спецразмещения'),
                pmax: ''
            };

        window.showVCGAuction && (valueTexts.pmax2 = iget('разницы до 1-го спецразмещения'));

        this.elem('label', 'mode', 'diff')
            .toggleClass('g-hidden', isPmax)
            .html(valueTexts[value]);

        this.elem('radio', 'mode', 'diff').toggleClass('g-hidden', isPmax);
        this.elem('radio', 'mode', 'price').prop('disabled', isPmax);

        if (isPmax) {
            this.elem('radio', 'mode', 'price').prop('checked', true);
            this.onRadioClick(); // onRadioClick добавлен для фикса DIRECT-13518
        }
        this.elem('radio', 'mode', 'diff').prop('disabled', isPmax);

    }

});

})(jQuery);
