(function($, Lego) {

    var thisBlock = Lego.block['b-prices-constructor__validator'] = function(params) {};
    thisBlock.api = {
        validatePrice: function (value, messages, limits) {
            var index = [+(value < (limits[0] || 0)), +(value > (limits[1] || 50)), +isNaN(value)].join('').indexOf('1');

            if (index + 1) {
                alert(messages[index]);
                return false;
            }
            return true;
        },

        validate: function(value, params, isContextPlace, isSearchPlace) {
            var currencyCode = params.currency || window.campCurrency, // код валюты
                 currency = get_currency(currencyCode); // валюта
            var priceAlerts = [
                    iget('Цена не может быть меньше %s', format_const(currencyCode, 'MIN_PRICE')),
                    iget('Цена не может быть больше %s', format_const(currencyCode, 'MAX_PRICE')),
                    iget('Неверно указана цена')],
                priceRange = [currency.MIN_PRICE, currency.MAX_PRICE],

                //  диапазон для процентов
                percRange = [0, 1000],
                // сообщения об ошибках, по порядку
                percAlerts = [
                    iget('Проценты не могут быть меньше ' + percRange[0] + '%'),
                    iget('Проценты не могут быть больше ' + percRange[1] + '%'),
                    iget('Неверно указаны проценты')],
                fixedPriceAlerts = [
                    iget('Фиксированная цена не может быть меньше %s', format_const(currencyCode, 'MIN_PRICE')),
                    iget('Фиксированная цена не может быть больше %s', format_const(currencyCode, 'MAX_PRICE')),
                    iget('Неверно указана фиксированная цена')];

            if (params.strategy == 'different_places') {
                if (isContextPlace) {
                    if (!params.isSimple) {
                        if (!thisBlock.api.validatePrice(value.proc_context, percAlerts, percRange)) { return false; };
                    }
                    if (!thisBlock.api.validatePrice(value.price_context, priceAlerts, priceRange)) { return false; }
                }
                if (isSearchPlace) {
                    if (!params.isSimple) {
                        if (!thisBlock.api.validatePrice(value.proc_search, percAlerts, percRange)) { return false; }
                    }

                    if (!thisBlock.api.validatePrice(value.price_search,  priceAlerts, priceRange)) { return false; }
                }
            } else {
                var suff =  value.platform == 'context' ? '_context' : '_search';
                if (value.platform == 'context') {
                    if (value.context_scope == 'fixed') {
                        if (!thisBlock.api.validatePrice(value['price' + suff], fixedPriceAlerts, priceRange)) return false;
                    }
                }
                if (!params.isSimple) {
                    if (!thisBlock.api.validatePrice(value['proc' + suff], percAlerts, percRange)) { return false; }
                }
                if (!thisBlock.api.validatePrice(value['price' + suff], priceAlerts, priceRange)) { return false; }
            }
            return true;
        }


    };


})(jQuery, window.Lego);

