(function($, Lego) {
    Lego.block['b-promo-commander'] = function(params) {
        var $this = $(this),

            $prev = $this.find('.b-promo-commander__slider__prev'),
            $next = $this.find('.b-promo-commander__slider__next'),
            $images = $this.find('.b-promo-commander__slider__images__i'),
            $first_image = $this.find('.b-promo-commander__slider__image__first'),
            $text = $this.find('.b-promo-commander__slider__text__content__container__i'),
            $nav = $this.find('.b-promo-commander__slider__pager__item'),

            n = $nav.length - 1,
            timeout = setTimeout(selectNext, 5000),

            $button = $this.find('.b-promo-commander__button'),
            $button_notes = $this.find('.b-promo-commander__button__notes'),
            $link = $this.find('.b-promo-commander__mac__link'),

            isMac = params.isMac,
            button_href = isMac ? params.href_mac : params.href_win,
            button_text = isMac ? params.button_text_mac : params.button_text_win,
            link_href = isMac ? params.href_win : params.href_mac,
            link_text = isMac ? params.link_text_win : params.link_text_mac,
            link_class = isMac ? 'b-promo-commander__mac__link_win' : '';

        $link.attr('href', link_href).text(link_text).addClass(link_class);
        $button.attr('href', button_href);
        $first_image.attr('src', params.firstImage);
        $button_notes.text(button_text);

        var cur = $nav.filter('.b-promo-commander__slider__pager__item_current').data('index');

        $nav.each( function() {
            var $item = $(this);
            $item.data('index', $nav.index($item));
        });

        function selectItem(i) {
            var delta_images = 520 * i,
                delta_text = 320 * i;
            $images.animate({ left: '-' + delta_images });
            $text.animate({ left: '-' + delta_text });
            $nav.eq(cur).removeClass('b-promo-commander__slider__pager__item_current');
            $nav.eq(i).addClass('b-promo-commander__slider__pager__item_current');
            cur = i;
        }

        function selectNext(repeat) {
            selectItem(cur < n ? cur + 1 : 0);
            timeout = (repeat == 'stop_repeat') ? clearTimeout(timeout) : setTimeout(selectNext, 5000);
        }

        function selectPrev() {
            selectItem(cur > 0 ? cur - 1 : n);
            timeout = clearTimeout(timeout);
        }

        $nav.click(function() {
            var i = $(this).data('index');
            if (i != cur) {
                selectItem(i);
            }
            timeout = clearTimeout(timeout);
        });

        $next.click(function() {
            selectNext('stop_repeat');
        });

        $prev.click(function() {
            selectPrev();
        });

    }
})(jQuery, window.Lego);
