(function($, Lego) {
    Lego.block['b-pseudo-clonator'] = function(params) {
        var $this = $(this),
            itemSel = '.b-pseudo-clonator__item',
            hiddenItemClass = 'b-pseudo-clonator__item_type_hidden',  // нет точки!
            hiddenItemSel = '.' + hiddenItemClass,
            addBtnSel = '.b-pseudo-clonator__btn_type_add',
            rmBtnSel = '.b-pseudo-clonator__btn_type_remove',
            addBtnDisabledClass = 'b-pseudo-clonator__btn_type_addhidden b-pseudo-clonator__btn_disabled_yes',  // нет точки!!
            rmBtnDisabledClass = 'b-pseudo-clonator__btn_type_removehidden b-pseudo-clonator__btn_disabled_yes',  // нет точки!!
            btnDisabledClass = 'b-pseudo-clonator__btn_disabled_yes',  // нет точки!!

            itemsNum = $this.find(itemSel).size();

        function refreshButtons() {
            $this
                .find(addBtnSel)
                .addClass(addBtnDisabledClass);

            $this
                .find(rmBtnSel)
                .addClass(rmBtnDisabledClass);

            var hiddenNum = $this.find(hiddenItemSel).size(),
                $lastItem = $this.find(itemSel).not(hiddenItemSel).last();

            if (hiddenNum > 0) {
                $lastItem
                    .find(addBtnSel)
                    .removeClass(addBtnDisabledClass);
            }

            if (itemsNum - hiddenNum > 1) {
                $lastItem
                    .find(rmBtnSel)
                    .removeClass(rmBtnDisabledClass);
            }
        }

        function hiddenItemsNum() {
            return $this.find(hiddenItemSel).size();
        }

        $this
            .find(addBtnSel)
                .bind('click', function() {
                    if ($(this).hasClass(btnDisabledClass)) return false;

                    if (hiddenItemsNum() < itemsNum) {
                        $this
                            .find(hiddenItemSel)
                            .first()
                            .removeClass(hiddenItemClass);

                        refreshButtons();
                    }
                })
            .end()
            .find(rmBtnSel)
                .bind('click', function() {
                    if ($(this).hasClass(btnDisabledClass)) return false;

                    if (itemsNum - hiddenItemsNum() > 1) {
                        $(this)
                            .closest(itemSel)
                            .addClass(hiddenItemClass)
                            .find('input,select,textarea')
                            .each(function(i, el) {
                                if (el.nodeName.toUpperCase() == 'SELECT') {
                                    el.selectedIndex = 0;
                                } else {
                                    el.value = '';
                                }
                            });

                        refreshButtons();
                    }
                });

        refreshButtons();
    };
})(jQuery, window.Lego);
