BEM.DOM.decl('b-quality-verdicts-list', {
    onSetMod: {
        js: function() {
            var _this = this;

            this.isExpanded = false;

            this.expandBtn = this.findBlockOn('expand-all-button', 'b-form-button');
            this.expandBtn && this.expandBtn.on('click', this.expandAll, this);

            //у this.elem('verdict') нет метода forEach
            this.elem('verdict').each(function(i, elem) {
                elem = $(elem);

                _this.findBlockInside(elem, 'b-pseudo-link').on('click', { elem: elem }, _this.expandBlock, _this);
            });
        }
    },

    /**
     * Сворачивает/разворачивает блок с подробным текстом
     * @param {Object} e
     * @param {Object} e.data
     * @param {Object} e.data.elem
     * @returns {BEM}
     */
    expandBlock: function(e) {
        this.toggleMod(e.data.elem, 'expanded', 'yes', '');

        return this.updateExpandedState();
    },

    /**
     * Обновляет состояние кнопки свернуть/разверунть все
     * @returns {BEM}
     */
    updateExpandButtonText: function() {
        this.expandBtn.elem('text').text(this.isExpanded ? iget('Свернуть все рекомендации') : iget('Развернуть все рекомендации'));

        return this;
    },

    /**
     * Обновлает состояние попапа this.isExpanded
     * @returns {BEM}
     */
    updateExpandedState: function() {
        var expanded = true,
            _this = this;

        this.elem('verdict').each(function(i, elem) {
            expanded = expanded && _this.getMod($(elem), 'expanded');
        });

        this.isExpanded = expanded;

        return this.updateExpandButtonText();
    },

    /**
     * Сворачиваем/разворачиваем список рекомендаций
     * @returns {BEM}
     */
    expandAll: function() {
        var _this = this;

        this.isExpanded = !this.isExpanded;

        this.elem('verdict').each(function(i, elem) {
            _this.setMod($(elem), 'expanded', _this.isExpanded ? 'yes' : '');
        });

        return this.updateExpandButtonText();
    }
}, {

});

BEM.HTML.decl('b-quality-verdicts-list', {
   onBlock: function(ctx) {
       var verdicts = ctx.param('verdicts');

       ctx
           .mix(ctx.param('mix'))
           .content([
           {
               elem: 'title',
               content:  ctx.param('title')
           },
           !!verdicts.length && {
               elem: 'verdicts-list',
               tag: 'ul',
               content: verdicts.map(function(verdict) {
                   return !!verdict && {
                       elem: 'verdict',
                       tag: 'li',
                       content: [
                           {
                               mix: [{ block: 'b-quality-verdicts-list', elem: 'verdict-title' }],
                               block: 'b-pseudo-link',
                               mods: { 'is-bem': 'yes' },
                               content: verdict.title
                           },
                           {
                               elem: 'verdict-recomendation',
                               content:  verdict.recomendation
                           }
                       ]
                   }
               })
           },
           (!verdicts.length) && {
               elem: 'verdicts-empty',
               content: iget('Продуктивность достаточна высокая.')
           },
           !!verdicts.length && {
               elem: 'controls',
               content: {
                   block: 'b-form-button',
                   mods: { theme: 'simple-lite-grey' },
                   mix: [{ block: 'b-quality-verdicts-list', elem: 'expand-all-button' }],
                   content: iget('Развернуть все рекомендации')
               }
           }
       ])
   }
});

