
BEM.DOM.decl({ name: 'b-region-selector', baseBlock: 'b-model-block' }, {

    onSetMod: {

        'js': function() {
            this.params.modelPath = 'campaign&banner:' + (this.params.bid || 0);
            this.params.modelName = 'b-regions-tree';
            this.__base.apply(this, arguments);
            this._bannerModel = BEM.blocks['i-models-manager'].get(this.params.modelPath, 'b-banner-edit');

            this._switcher = this.findBlockOn('button', 'b-form-button');
            this._switcher.on('click', this.popupToggle, this);
            this.model.initField('geo', this.elem('geo').val(), this);
            this.model.on('change', this.onModelChange, this);

            this._oldModel = this.params.model;
        }

    },

    /**
     *  Обработчик события клика по кнопке выбора регионов
     * @returns {BEM}
     */
    popupToggle: function() {
        this._popup || this.popupInit();

        this._popup.isShowed() && this.model.rollback();
        this._popup.toggle(this._switcher.domElem);

        var tree = this.getTree(),
            _this = this;

        if (tree) {
            tree.fillInputsFromModel();

            return this;
        }

        this._showLoadingSpin();

        this.__self._ajaxLoader.get(this.params.requestParams || {},
            function(data) {
                BEM.DOM.update(_this._popup.elem('center'), $(data), function() {
                    var regionsBlock = this._popup.findBlockInside('b-regions'),
                        regionsTree = regionsBlock.findBlockOn('regions-tree', 'b-regions-tree'),
                        input = regionsBlock.findBlockOn('search-input', 'b-form-input'),
                        inputId = direct.utils.generateId(),
                        params = this.params;

                    tree = this.getTree();
                    regionsTree.elem('geo').val(params.geo);
                    regionsTree.elem('geo_text').val(params.geoText);
                    regionsTree.elem('product_type').val(params.productType);

                    input.elem('hint').attr('for', inputId);
                    input.elem('input').attr('id', inputId);

                    tree && tree
                        .initTreeModel(params.modelPath)
                        .fillInputsFromModel()
                        .start()
                        .onShow();

                }, _this);
            },
            {
                dataType: 'html'
            }
        );

        return this;
    },

    _showLoadingSpin: function() {
        BEM.DOM.update(this._popup.elem('center'), BEM.HTML.build({
            block: 'b-region-selector',
            elem: 'loading-spin',
            tag: 'img',
            attrs: {
                src: '/i/ajax-loader.gif'
            }
        }));
    },

    /**
     * Инициализация событий всплывающего окна и его элементов
     * @returns {BEM}
     */
    popupInit: function() {
        var popup = this._popup = this.findBlockOn('popup', 'b-popupa');

        popup.findBlockOn('submit', 'b-form-button')
            .on('click', this.onPopupSubmit, this);

        popup.findBlockOn('cancel', 'b-form-button')
            .on('click', this.onPopupCancel, this);

        popup
            .on('show', this.onPopupShow, this)
            .on('outside-click', function(e) { return false; })
            .bindTo('close', 'click', $.proxy(this.onPopupCancel, this));

        this.__self.on('open', function(e, elem) {
            if (elem != this && this._popup.isShowed()) {
                this._popup.hide();
            }
        }, this);

        return this;
    },

    /**
     * Обработчик события изменения модели
     * @returns {BEM}
     */
    onModelChange: function() {
        var geo = this.model.get('geo'),
            geoText = this.getGeoText();

        this._oldModel && this._oldModel.update({ common: { geo: geo.replace(/\s/g, ''), geo_text: geoText } });
        this.trigger('change-geo', { geo: geo, geoText: geoText });
        this.setMod(this.elem('geo-warning'), 'show', geo != '0' ? 'no' : 'yes');
        this._bannerModel && this._bannerModel.set('geo', geo);

        return this;
    },

    /**
     * Обработчик события отображения всплывающего окна
     * @returns {BEM}
     */
    onPopupShow: function() {
        this.__self.trigger('open', this);

        return this;
    },

    /**
     * Обработчик события клика по кнопке отмена
     * @returns {BEM}
     */
    onPopupCancel: function() {
        this.model.rollback();
        this._popup.hide();

        return this;
    },

    /**
     * Обработчик события клика по кнопке ОК всплывающего окна
     * @returns {Boolean}
     */
    onPopupSubmit: function() {
        if (!this.model.validate()) return false;

        var tree = this.getTree();

        if (!tree) return false;

        tree.finish();

        this.fillToServerFromModel();
        this.model.fixData();
        this._popup.hide();
        BEM.DOM.update(this.elem('geo-text-fact'), this.getGeoText());

        return true;
    },

    /**
     * Метод доступа к блоку b-regions-tree
     * @returns {BEM}
     */
    getTree: function() {
        return this._tree || (this._tree = this._popup.findBlockInside('b-regions-tree'));
    },

    /**
     * Возвращает гео-текст текущего набора регионов
     * @returns {String}
     */
    getGeoText: function() {
        var block = BEM.blocks['b-regions-tree'],
            text = block ? block.getText(this) : '';

        return this.model.get('geo') != '0' ? text : this.params.allRegionsText;
    }
},
{
    _ajaxLoader: BEM.create('i-request_type_ajax', {
        cache: true,
        url: location.toString(),
        type: 'POST'
    })

});

