(function($, Lego){
    /**
     * Саджест по регионам. Основан на b-suggest /lego/versions/2.0/common/block/b-suggest@5297
     */

    var MAX_ITEMS = 15,
        CLASS_NAME_PREFIX = 'b-region-suggest',
        ELEMENT_CLASS_NAME = CLASS_NAME_PREFIX + '__elem';
        SELECTED_CLASS_NAME = CLASS_NAME_PREFIX + '__elem_selected';

    var dataCache = {},
        dataListeners = {};

    /**
     * Кэширующий загрузчик.
     * Одновременно могут прийти несколько запросов на 1 урл.
     * В этом случае мы ждем делаем только один реальный запрос,
     * и после того как он завершится дергаем все колбэки
     * для этого урла.
     */
    function loadData (id, url, callback) {
        function notifyListeners (url) {
            $.each(dataListeners[url], function(i, callback) { callback(dataCache[url]) });
            dataListeners[url] = null;
        }

        if (dataListeners[url]) {
            dataListeners[url].push(callback);
        } else {
            dataListeners[url] = [callback];
            if (dataCache[url]) {
                notifyListeners(url);
            } else {
                window[id] = function(data) {
                    dataCache[url] = data;
                    notifyListeners(url);
                };

                var head = document.getElementsByTagName("head")[0],
                    script = document.createElement("script");
                script.src = url.replace(/callback=\?/, 'callback=' + id);
                head.appendChild(script);
            }
        }
    }

Lego.block['b-region-suggest'] = function(params){
    var thisSuggest = $(this),
        suggestHolder = $('<div class="' + CLASS_NAME_PREFIX + '__list">' +
            '<iframe frameborder="0" class="' + CLASS_NAME_PREFIX + '__iframe" src="javascript:' + "'<body style=\\'background:none\;overflow:hidden\\'>'" + '"></iframe>' +
            '<ul class="' + CLASS_NAME_PREFIX + '__items"></ul>' +
            '</div>').hide(),
        suggestItems  = suggestHolder.find('.' + CLASS_NAME_PREFIX + '__items'),
        suggestInput  = thisSuggest.closest('form').find('input[name="' + (params['for'] || 'text') +'"]'),
        suggestHidden = thisSuggest.find('input[type="hidden"]'),
        parent        = params.parent ? $(params.parent) : null,
        phone         = params.phone  ? $(params.phone) : null,

        dataUrl  = params.url,
        data,     // все регионы
        requestid = params.requestid || dataUrl.replace(/^.*\//, '').replace(/\?.*$/, ''),

        current,  // текущий выбранный элемент
        filtered, // отфильтрованные регионы
        query,    // текущее значение поискового запроса
        parentId, // текущее значение родителя
        hidden = true,          // храним факт скрыты ли подсказки
        hideInProgress = false, // переменная для синхронизации событий закрытия и ухода из инпута
        changedAfterSelect = false, // было ли поле изменено с момента последнего селекта

        keypressTimeout;

    suggestInput.blur().attr('autocomplete', 'off');
    thisSuggest.append(suggestHolder);
//    setDisabled(true, params.loadingText || 'Загрузка\u2026');
    loadData(requestid, dataUrl, function(loadedData) {
        data = loadedData;
        if (!parent) {
//            setDisabled(false);
            fillParentFirst();
            if (params.focus) suggestInput.focus();
        }
        bindEvents();
    });



    function bindEvents () {
        $(document).bind('popupsClose.lego', hide);

        if (parent) {
            parent.bind('regionIdChanged', function(e, newParentId){
                if (parentId != newParentId) {
                    var data;

                    // ищем город с таким названием для выбранного parentId
                    if (suggestInput.val().match(/\S/)) {
                        data = findAllDataByNameAndParentId(suggestInput.val(), newParentId);
                    }
                    writeSelected(data ? data.id : '', data ? getName(data, suggestInput.val()) : '');
                }
                parentId = newParentId;
                hidden || hide();
            });

            parentId = parent.data('regionId');
            fillChildFirst(parentId);
        }

        suggestInput.blur(function(){
            hideInProgress || hide();
            var val = $.trim(suggestInput.val());
            if (changedAfterSelect) {
                //если не было выбора из списка, но название введено правильно - выбираем его автоматически
                if (filtered && filtered.length >= 1 &&
                    isEqualToName(val, filtered[0])) {
                    select(0);
                } else {
                    writeSelected('', val);
                }
            }
        });

        suggestItems
            .mousedown(function(e) {
                changedAfterSelect = false;
                hideInProgress = true;
            })
            .click(function(e) {
                var t = $(e.target);
                suggestInput.focus();
                if (t.is('li *')) {
                    highlight(t.closest('li').attr('suggest_position'));
                    select(current);
                    hide();
                } else {
                    hideInProgress = false; // в любом случае чистим
                }
            });

        suggestInput
            .keydown(function(e){
                switch(e.keyCode) {
                    // нажатие стрелок перемещает курсор и открывает список если он закрыт
                    case 38: // UP
                    case 40: // DOWN
                        e.preventDefault();
                        hidden ? show() : highlightByOffset(e.keyCode - 39); // пользуемся особенностями кодов клавиш "вверх"/"вниз" ;-)
                        break;

                    case 27: // ESC
                        hideInProgress = true;
                        break;
                }
            })
            .keypress(function(e) {
                switch(e.keyCode) {
                    case 13: // Enter
                        e.preventDefault();
                        return false;

                    // прячем при нажатии Esc
                    case 27: // ESC
                        highlight(0);
                        suggestInput.focus();
                        hide();
                        return false;

                }
            })
            .keyup(function(e){
                switch(e.keyCode) {
                    // при нажатии Enter выбираем текущий элемент
                    case 13: // Enter
                        e.preventDefault();
                        select(current);
                        hide();
                        return false;

                    default:
                        var newQuery = suggestInput.val();
                        if (newQuery != query) {
                            changedAfterSelect = true;
                            clearInterval(keypressTimeout);
                            keypressTimeout = setTimeout(show, 1); // задержка для тех, кто быстро печатает
                        }
                        break;
                }
            }).bind('regionSuggest.change', function(e) {
                params.text = suggestInput.val();
                fillFromLoadedData();
//                setDisabled(parent && !params.text.match(/\S/))
            });
    }

    function filter () {
        var found = 0, region;
        filtered = [];
        query = $.trim(query); // DIRECT-12006

        for (var i=0; i < data.length; i++) {
            region = data[i];
            if (
                (isMatchToName(query, data[i])) &&
                (!parentId || region.parentId == parentId)
            ) {
                filtered.push(region);
                if (++found >= MAX_ITEMS) break;
            }
        };
        return filtered;
    }

    function buildListHtml () {
        return $.map(filtered, function(region, index) {
            var name = '<strong>' + getName(region).substring(0, query.length) + '</strong>' + getName(region).substring(query.length);
            return '<li suggest_position="' + index + '"><a class="' + ELEMENT_CLASS_NAME + '">' + name + '</a></li>'
        }).join('')
    }

    function show () {
        $(document).trigger('popupsClose.lego');
        query = suggestInput.val();
        if (!query.match(/\S/)) {
            hide();
        } else {
            filter();
            if (query.length < 3) { return false; }
            suggestItems[0].innerHTML = buildListHtml(filtered);
            suggestHolder[filtered.length ? 'show' : 'hide']();
            current = -1;
            hidden = false;
        }
    }

    function hide () {
        if (hidden) return;
        suggestHolder.hide();
        hidden = true;
        hideInProgress = false;
    }

    function highlightByOffset (offset) {
        highlight(current + offset);
    }

    function highlight (newCurrent) {
        if (!filtered.length) return;

        current = Math.min(Math.max(newCurrent, 0), filtered.length - 1);

        suggestItems.find('.' + SELECTED_CLASS_NAME).removeClass(SELECTED_CLASS_NAME);
        suggestItems.find('.' + ELEMENT_CLASS_NAME + ':eq('+ current+')').addClass(SELECTED_CLASS_NAME);
    }

    function select (i) {
        if (!i && i !== 0) return;
        if (!filtered[i]) return;
        writeSelected(filtered[i].id, getName(filtered[i]), filtered[i].code)
    }

    function writeSelected (id, name, phoneCode, skipNotification) {
        changedAfterSelect = false;
        suggestInput.val(name || '');
        //чтобы событие могли обработать все кто ловит onchange для полей ввода
        suggestInput.change();
        suggestHidden.val(id);
        if (!skipNotification) thisSuggest.trigger('regionIdChanged', id);
        thisSuggest.data('regionId', id);

        if (phoneCode) {
            //fixed DIRECT-4969
            if (dataUrl.match(/cities/) && phoneCode.match(/^0/)) {
                phoneCode = phoneCode.split(/\s/)[1] ? phoneCode.split(/\s/)[1] : phoneCode.split(/\s/)[0]
            } else {
                phoneCode = phoneCode.split(/\s/)[0];
            }
            if (dataUrl.match(/countries/) && !phoneCode.match(/\+/) &&
                phoneCode != 8) // DIRECT-15924 - Принимать код России 8 в визитке / DIRECT-29570
                // (т. к. номер может быть 8 800, а местоположение не обязательно Россия, то приходится не подставлять + только к 8)
                phoneCode = '+' + phoneCode;
        }

        phone && phone.val(phoneCode || '').change();
        query = name;
    }

    function findById (id) {
        for (var i=0; i < data.length; i++) {
            if (data[i].id == id) return data[i];
        };
        return {};
    }



    function getName(data) {
        var lang = Lego.params.locale;
        switch(lang) {
            case 'en':
                return data.enname || data.name;
            case 'tr':
                return data.trname || data.enname || data.name;
            case 'uk':
                return data.ukname || data.name;
            default:
                return data.name;
        }
    }

    function strPreprocess(str) {
        var lang = Lego.params.locale;
        if (!str) { str = ''; }
        //DIRECT-17738 - турецкие символы могут менять смысл из-за перегонки в верхний/нижний регистр
        return lang != 'tr' ? str.toLowerCase() : str;
    }

    function isMatchToName(query, data) {
        query = strPreprocess(query);
        var name = getName(data);
        if (name && strPreprocess(name).indexOf(query) == 0) {
            return true
        }
        return false;
    }


    function isEqualToName(name, data) {
        name = strPreprocess(name)
        if (strPreprocess(getName(data)) == name) {
            return true;
        }
        return false;
    }

    function findIdByName(name) {
        for (var i = 0; i < data.length; i++) {
            if (isEqualToName(name, data[i])) return data[i].id;
        }
    }

    function findAllDataByNameAndParentId(name, parentId) {
        for (var i = 0; i < data.length; i++) {
            if (data[i].parentId == parentId && isEqualToName(name, data[i])) return data[i];
        }
    }

    function findAllDataByName(name) {
        for (var i = 0; i < data.length; i++) {
            if (isEqualToName(name, data[i])) return data[i];
        }
    }

    function findPhoneById(id) {
        for (var i = 0; i < data.length; i++) {
            if (data[i].id == id) return data[i].code;
        }
    }

    //заполнение поля города при первой загрузке с учетом введенных ранее данных
    function fillChildFirst(parentId) {
        params.text = suggestInput.val();
        params.phoneCode = phone.val();
        if (parentId && (params.text || params.id)) {
            var data = params.id ? findById(params.id) : findAllDataByName(params.text);

            if (data) {
                var parentIdInner = data.parentId;
            }

            if (!parentId || parentIdInner == parentId) {
                parentId = parentIdInner;
                params.id = data.id;
                params.phoneCode = params.phoneCode || data.code || '';
                writeSelected(params.id, params.text, params.phoneCode, true);
                params.id = params.text = params.phoneCode = '';
            }
        }
    }

    function fillParentFirst() {
        params.text = suggestInput.val();
        if (phone) {
            params.phoneCode = phone.val();
        }

        if (params.text) {
            var data = findAllDataByName(params.text);
            if (data) {
                params.phoneCode = params.phoneCode || data.code || '';
                writeSelected(data.id, params.text, params.phoneCode, true);
            }
        }
        params.id = params.text = params.phoneCode = '';
    }

    function fillFromLoadedData() {
        if (params.id && !params.text) {
            params.text = getName(findById(params.id));
        }
        if (params.text && !params.id) {
            params.id = findIdByName(params.text);
        }
        if (params.id && phone && !params.params) {
            params.phoneCode = findPhoneById(params.id)
        }
        writeSelected (params.id || '', params.text || '', params.phoneCode || '');
        params.id = params.text = params.phoneCode = '';
    }


};

})(jQuery, window.Lego);
