(function($) {
    BEM.DOM.decl({name:'b-regions-tree-leaf'}, {
        onSetMod: {
            js: function() {
                this.parent = this.params.parent;
                this.children = this.params.children;
                this.text = this.params.text;
                this.regionId = this.params.regionId;
                this.expandable = this.getMod('expandable');

                this
                    .bindTo('sign', 'leftclick', this.onExpandClick)
                    .bindTo('checkbox', 'leftclick', this.onCheckClick);
            }
        },

        getChildren: function() {
            if (!this.children ) {
                var childrenStr = this.elem('children').val();
                this.children = childrenStr ? childrenStr.split(',') : '';
            }
            return this.children;
        },

        onExpandClick: function(e) {
            var expanded = this.getMod('expanded') == 'no';
            BEM.blocks['b-regions-tree-leaf'].trigger('expand', { id: this.regionId, expanded: expanded } );
            this.expand(expanded);
        },

        expand: function(expanded) {
            this.setMod('expanded', expanded ? 'yes' : 'no');
            return this;
        },


        getText: function() {
            return this.text;
        },

        getParentId: function() {
            return this.parent
        },

        isChecked: function() {
            return this.getMod('checked') == 'yes';
        },

        getId: function() {
            return this.regionId;
        },

        disable: function(disabled) {
            this.elem('checkbox').add(this.elem('title')).prop('disabled', disabled);
            this.setMod('expandable', disabled ? 'no' : this.expandable)
            return this.setMod('disabled', disabled ? 'yes' : 'no');
        },

        isDisabled: function() {
            return this.getMod('disabled') == 'yes';
        },


        onCheckClick: function(e) {
            if (this.getMod('disabled') == 'yes') return false;
            var checked = e.data.domElem.prop('checked');
            this.setMod('checked', checked ? 'yes' : 'no');
            BEM.blocks['b-regions-tree-leaf'].trigger('checked', { checked: checked, id: this.regionId });
        },

        check: function(checked) {
            this.elem('checkbox').prop('checked', checked);
            this.setMod('checked', checked ? 'yes' : 'no');
            return this;
        },

        /**
         * Подсветка подстроки, совпадающей с началом слова в названии ноды
         * @param subst подстрока, если не задан подсвечивается весь текст
         * @returns {BEM}
         **/
        highlightSubstring: function(subst) {
            var text = this.getText(),
                words = text.toLowerCase().split(/\s|-/),
                matchedWord = '';

            !subst && (subst = text);

            // искомая подстрока должна быть в начале слова
            $.each(words, function(i, v) {
                if (v.indexOf(subst.toLowerCase()) == 0) {
                    matchedWord = v;
                }
            });

            var pos = text.toLowerCase().indexOf(matchedWord);
            if (pos != -1) {
                var endHl = pos + subst.length;

                BEM.DOM.update(this.elem('label'),
                    text.slice(0, pos) +
                    BEM.HTML.build([{
                        block: 'b-regions-tree-leaf',
                        elem: 'highlighted',
                        content: text.slice(pos, endHl)
                    }]) +
                    text.slice(endHl)
                );
            }

            return this;
        },

        /**
         * Метод удаляет подсветку подстроки
         * @returns {BEM}
         **/
        resetHighlight: function() {
            BEM.DOM.update(this.elem('label'), this.getText());

            return this;
        },

        /**
         * Скролл дерева к текущей ноде
         * @returns {BEM}
         **/
        scrollTo: function() {
            var container = this.findBlockOutside('b-regions-tree').elem('container');

            container.scrollTop(this.domElem.position().top  + container.scrollTop());

            return this;
        }

    }, {
        live: true
    });

    BEM.HTML.decl('b-regions-tree-leaf', {

        onElem: {

            'highlighted': function(ctx) {
                ctx.tag('span')
            }
        }
    });

})(jQuery);
