(function($) {

    BEM.blocks['b-model'].register('b-regions-tree', {
        fields: {
            'product_type': {type: 'string', fromServer: 1, toServer: 0, input: 1},
            'geo': {type: 'string', fromServer: 1, toServer: 1, input: 1},
            'geo_text': {type: 'string', fromServer: 1, toServer: 1, input: 1}
        },

        validateRules: {

        },

        errorsMessages: {

        }
    });

    BEM.DOM.decl({name:'b-regions-tree', baseBlock: 'b-model-block'}, {
        onSetMod: {
            js: function() {
                //уже проинициализированные листья дерева
                this.leaves =  {};
                this._leavesOrder = [];
                this.blocks = {};
                this.initTree();
                this.initTreeModel(this.params.modelPath || 'user');
                this.selectTree();
                BEM.blocks['b-regions-tree-leaf']
                    .on('expand', this.onLeafExpand, this)
                    .on('checked', this.onLeafCheck, this)
            }
        },

        initTreeModel: function(modelPath) {
            this._modelPath = modelPath;
            this._modelName = 'b-regions-tree';
            this.initModel();
            this.bindEvents();

            return this;
        },

        fillInputsFromModel: function() {
            this.adjustQuickSelect();
            this.selectTree();

            return this;
        },

        onExternalChange: function(e, data) {
            if (data.source == this) return;
            this.fillInputsFromModel();
            this.finish();
            this.model.fixData();
        },

        bindEvents: function() {
            this.__base();
            this.bindTo('quick', 'click', this.quickChoose)
        },

        adjustQuickSelect: function() {
            this.elem('quick-no-regional').toggleClass('g-hidden', this.model.get('product_type') == 'mcb_regional')
        },

        quickChoose: function(e) {
            this.clearTree();
            this.setDisabled();

            var value = this.getMod($(e.data.domElem), 'val');

            if (value == 'clear') { return; }

            var ids = value.split('i'),
                valueToFormat = ids.join(',');

            this.selectTree(valueToFormat);
            this.leaves[ids[0]].scrollTo();
        },



        onLeafExpand: function(e, data) {
            this.expandLeaf(data.id, data.expanded)
        },


        expandLeaf: function(id, expanded) {
            this.setMod(this.blocks[id], 'hidden', expanded ? 'no' : 'yes');
        },

        onLeafCheck: function(e, data, otherStatesArr) {
            this.leaves[data.id].expand(data.checked);
            this.expandLeaf(data.id, data.checked);
            this.checkChildren(data.id, data.checked, otherStatesArr);
            // DIRECT-49315
            //this.checkParent(data.id, data.checked);
        },

        //checkParent: function(id, checked) {
        //    var leaf = this.leaves[id],
        //        parentId = leaf.getParentId();
        //
        //    if (!parentId) return;
        //
        //    var parent = this.leaves[parentId];
        //
        //    if (parent.isChecked()) {
        //        var allNotChecked = true,
        //            children = parent.getChildren();
        //
        //        for (var i = 0, l = children.length; i < l; i++) {
        //            if (this.leaves[children[i]].isChecked()) {
        //                allNotChecked = false;
        //                break;
        //            }
        //        }
        //
        //        allNotChecked && parent.check(false);
        //    }
        //
        //    this.checkParent(parentId, checked);
        //},

        checkChildren: function(id, checked, otherStatesArr) {
            otherStatesArr = otherStatesArr || [];

            var _this = this,
                children = this.leaves[id].getChildren();
            children && $.map(children, function(id) {
                if (_this.leaves[id].isDisabled() || $.inArray(id, otherStatesArr) !== -1) return this;
                _this.leaves[id].check(checked);
                _this.checkChildren(id, checked, otherStatesArr);
            })
        },

        initTree: function() {
            var _this = this;

            $.map(this.findBlocksInside('b-regions-tree-leaf'), function(leaf) {
                var id = leaf.getMod('id');

                _this.leaves[id] = leaf;
                _this._leavesOrder.push(id);
            });
            $.map(this.elem('children'), function(elem) {
                elem = $(elem);
                _this.blocks[_this.getMod(elem, 'id')] = elem;
            })

        },

        clearTree: function() {
            var _this = this;

            $.each(this.leaves, function(id, leaf) {
                leaf.check(false);
                leaf.disable(false);
                leaf.expand(false);
                _this.expandLeaf(id, false);
            });
        },

        expandParent: function(id) {
            var parentId = this.leaves[id].getParentId();
            if (!parentId) { return; }
            this.leaves[parentId].expand(true);
            this.expandLeaf(parentId, true);
            this.expandParent(parentId)
        },

        selectTree: function(geo) {
            var _this = this,
                id, checked = [], unchecked = [],
                geo = geo || this.model.get('geo'),
                rs = geo.split(',');
            this.clearTree();

            $.map(rs, function(num) {
                if (!num || num == '0') { return true; }
                id = ''+Math.abs(num);

                if (+num > 0) {
                    checked.push(id);
                } else {
                    unchecked.push(id)
                }
            });

            $.map(checked, function(id) {
                _this.expandParent(id);
                _this.leaves[id].check(true);
                _this.onLeafCheck({}, {id: id, checked: 1}, unchecked);
            });

            $.map(unchecked, function(id) {
                _this.leaves[id].check(false);
                _this.onLeafCheck({}, {id: id, checked: 0}, checked);
            });

            _this.setDisabled();

        },

        setDisabled: function() {
            var _this = this;
            /*
             для задачи DIRECT-15910 в случае когда у нас медийный продукт mcb_regional
             хардкодим дизейбл Москвы и области (id: 'region1') и Спб с областью (id: 'region10174')
             */
            if (this.model.get('product_type') == 'mcb_regional') {
                $.map(['1', '10174'], function(id) {
                    _this.expandLeaf(id, false);
                    _this.leaves[id].check(false).expand(false).disable(true);
                    _this.onLeafCheck({}, {id: id, checked: 0});
                });
            }
        },

        getLastCheckedParent: function(id) {
            var parentId = this.leaves[id].getParentId(),
                parentChecked = parentId && this.leaves[parentId].getMod('checked') == 'yes';
            return parentChecked ? this.getLastCheckedParent(parentId) : id;
        },


        finish: function() {
            var regions = {},
                order = [],
                _this = this;

            $.each(_this._leavesOrder, function(n, id) {

                var leaf = _this.leaves[id],
                    checked = leaf.getMod('checked') == 'yes',
                    lastCheckedParentId = _this.getLastCheckedParent(id);

                if (checked && lastCheckedParentId == id && !regions[id]) {
                    regions[id] = [];
                    order.push(id);

                } else if (!checked && lastCheckedParentId != id) {

                    if (!regions[lastCheckedParentId]) {
                        regions[lastCheckedParentId] = []
                        order.push(lastCheckedParentId);
                    }

                    /* DIRECT-22138 */
                    var uncheckedChildren = [],
                        children = leaf.getChildren();

                    for (var i = 0, l = children.length; i < l; i++) {
                        _this.leaves[children[i]].isChecked() || uncheckedChildren.push(children[i]);
                    }

                    if (uncheckedChildren.length == children.length) {
                        regions[lastCheckedParentId].push(id);
                    } else {
                        regions[id] = uncheckedChildren;
                        order.push(id);
                    }
                }
            });
            var geo = [], geoText = [], textTmp, exeptionTexts = [];
            $.each(order, function(n, id) {
                var block = regions[id];
                
                geo.push(id);
                textTmp = _this.leaves[id].getText();
                if (block.length) {
                    exeptionTexts = [];
                    $.map(block, function(exId) {
                        geo.push(-exId);
                        exeptionTexts.push(_this.leaves[exId].getText());
                    });
                    textTmp += ' (' + iget('кроме') + ' ' + exeptionTexts.join(', ') + ')';
                }
                geoText.push(textTmp)
            });
            this.model.update({
                'geo': geo.join(', ') || '0', //#DIRECT-18525
                'geo_text': geoText.join(', ') || this.params.allRegionsText
            }, this);
        },



        confirm: function() {
            if (this.model.isFieldChanged('geo')) {

                if (this.model.get('geo') == '0') {
                    return confirm (
                        iget('Будет установлен ЕДИНЫЙ регион для всех объявлений в кампании: \n%s', this.params.allRegionsText));
                } else if (this.model.getFieldStartValue('geo') === '') {
                    return confirm(iget('Будет установлен ЕДИНЫЙ регион для всех объявлений в кампании.'));
                }
            }
            return true;
        },

        /**
         * Возвращает массив названий всех регионов
         * @return {Array} Массив названий всех регионов
         */
        getAllRegionsText : function() {
            var result = [];
            $.each(this.leaves, function(i, v) {
                result.push(v.getText());
            });

            return result;
        }
    }, {

        getButtonText: function(ctx) {
            return ctx.model.get('geo') == '0' ? iget('задать') : iget('изменить');
        },

        getText: function(ctx) {
            return ctx.model.get('geo_text') +
                (ctx.model.get('product_type') == 'mcb_regional' ?
                    '<div style="color: black !important; margin-top: .5em;">' +
                        '<img src="/i/warning.gif" width="16" height="13" alt="!"/> ' +
                        iget('Для регионального МКБ Московская и Ленинградская область недоступны для показа') +
                        '</div>' :
                    '');
        }
    });

})(jQuery);
