(function ($) {

    BEM.DOM.decl('b-regions', {

        onSetMod: {

            js: function() {
                var input = this._searchInput = this.findBlockOn('search-input', 'b-form-input'),
                    tree = this._regionsTree = this.findBlockOn('regions-tree', 'b-regions-tree');

                input.getDataprovider().init(tree.getAllRegionsText());

                input
                    .on('select', function(item) {
                        this.search(item.block._val, false);
                    }, this)
                    .on('clear', function () { this.hideLastResult(); }, this);

                this.findBlockOn('search-button', 'b-form-button')
                    .on('click', function() {
                        this.search($.trim(input.val()), true);
                    }, this);

                input.bindTo('input', 'keypress', $.proxy(function(e) {
                    if ((e.keyCode == 13) && (input._curItemIndex == -1)){
                        this.search($.trim(input.val()), true);
                        input._getPopup().hide();
                    } else {
                        this.hideLastResult();
                    }

                }, this));

                tree.bindTo('quick', 'click', $.proxy(function() {
                    this.hideLastResult();
                }, this));

                // дополнительная функциональность поиска чанками
                $.extend(tree, common.Searchable, {

                    chunkTimeout: 10,

                    /**
                     * Инициализация поиска
                     * @param finishCallback вызывается при завершении поиска
                     */
                    initSearch: function(finishCallback) {
                        this.unbind('search.finish');
                        if (typeof finishCallback == 'function') {
                            this.bind('search.finish', finishCallback);
                        }

                        this.items = [];
                        $.each(this.leaves, $.proxy(function (i, v) {
                            var text = v.getText().toLowerCase(),
                                words = text.split(/\s|-/);

                            if (words.length > 1) words.push(text);

                            this.items.push({ leaf: v, textByWords: words });
                        }, this));
                    },

                    /**
                     * Запуск поиска
                     * @param query искомая строка
                     * @param partialModeOn вкл/откл режима поиска частичного совпадения
                     */
                    search: function(query, partialModeOn) {
                        if (query == '') return;

                        this._partialModeOn = partialModeOn;
                        this._lastResult = [];

                        common.Searchable.search.call(this, query.toLowerCase(),
                            $.proxy(this.regionFound, this));
                    },

                    /**
                     * Матчер текущего элемента поиска
                     * @param row
                     * @param iterator
                     * @return {Boolean}
                     */
                    matchRow: function(row, iterator) {
                        var result = false,
                            query = iterator.query,
                            text = row.leaf.getText().toLowerCase();

                        if (!this._partialModeOn) {
                            (text == query) && (result = text);
                        } else {
                            $.each(row.textByWords, function(i, v) {
                                if (!v.indexOf(query)) result = v;
                            });
                        }

                        return result;
                    },

                    /**
                     * Callback при нахождении искомого элемента
                     * @param item элемент
                     * @param iterator объект итерации
                     */
                    regionFound: function(item, iterator) {
                        this._lastResult.push(item.leaf);
                        this.expandParent(item.leaf.getId());
                        this._partialModeOn && item.leaf.highlightSubstring(iterator.query);
                    }
                });

                // инициализация поиска (единственным аргументом передаем callback, вызываемый
                // при завершении поиска
                tree.initSearch($.proxy(function() {
                    var result = tree._lastResult,
                        length = result.length,
                        foundLabel = this.elem('found-label');

                    if (tree._partialModeOn) {
                        length && result[0].scrollTo();
                        foundLabel.html(length ? iget('Найдено: %s', length) : iget('Ничего не найдено'));
                        this.setMod(foundLabel, 'display', 'yes');
                    } else {
                        if (length > 0) {
                            var selLeaf = result[length - 1];

                            tree.expandLeaf(selLeaf.getId(), true);
                            selLeaf.scrollTo()
                                   .expand(true)
                                   .highlightSubstring();

                            this.setMod(this.elem('found-label'), 'display', 'no');
                        }
                    }

                    this._viewResultOn = true;
                }, this));
            }
        },

        /**
         * Поиск в дереве регионов
         * @param query искомая строка
         * @param partialModeOn вкл/откл режима поиска частичного совпадения (аналога поиска в браузере)
         *
         */
        search: function(query, partialModeOn) {
            if (query == '') return;

            var tree = this._regionsTree,
                pos = this._foundPos;

            if ((tree._partialModeOn != partialModeOn) ||
                (this._lastQuery != query)) {

                this.hideLastResult();
                tree.search(query, partialModeOn);
                this._lastQuery = query;
                this._foundPos = 0;
            } else {
                var result = tree._lastResult;

                if (!result.length) return;

                $.each(result, function(i, v) {
                    tree.expandParent(v.getId(), true);
                });

                this._foundPos = pos = (pos == result.length - 1) ? 0 : pos + 1;
                result[pos].scrollTo();
            }
        },

        /**
         * Метод скрывает результаты предыдущего поиска
         */
        hideLastResult : function() {
            if (!this._viewResultOn) return;

            var tree = this._regionsTree;

            if (tree._lastResult) {
                $.each(tree._lastResult, function (i, v){
                    v.resetHighlight();
                })
            }

            this.setMod(this.elem('found-label'), 'display', 'no');
            this._viewResultOn = false;
            this._lastQuery = undefined;
            this._lastResult = undefined;
        }
    });
})(jQuery);
