(function($){

BEM.DOM.decl('b-replace-goals', {
    onSetMod: {
        'js': function(){
            var self = this;

            this.__self.instance = this;
            this.popup = this.findBlockInside('b-popupa');

            self.cancel = self.findBlockOn(self.elem('cancel'), 'b-form-button').on('click', $.proxy(self.cancel,self));
            self.save = self.findBlockOn(self.elem('save'), 'b-form-button').on('click', $.proxy(self.save, self)) ;

        }
    },

    toggle: function(goals) {
        this.initStopGoals(goals);
        this.popup.toggle(this.domElem)
    },

    initStopGoals: function(stopGoals) {
        var self = this,
            goals = BEM.blocks['i-get-goals-ajax'].getGoals(),
            content = [];

        this.stopGoals = stopGoals;
        for (var i = 0; i < goals.length; i++) {
            var goal = goals[i];
            goal.allow_to_use && content.push({
                tag: 'option',
                attrs: { value: goal.goal_id },
                content: goal.goal_domain + ' :: ' + goal.goal_name
            })
        }

        this.elem('error').html('');
        self.elem('tbody').empty();

        $.each(this.stopGoals, function(i, goal) {
            self.elem('tbody').append(BEM.HTML.build({
                tag: 'tr',
                block: self.__self.getName(),
                elem: 'tr',
                mods: {'id': goal.goal_id},
                cls: 'b-table__tr',
                content: [
                    {
                        tag: 'td',
                        cls: 'b-table__td',
                        block: self.__self.getName(),
                        elem: 'td',
                        content:  goal.goal_domain + ' :: ' + goal.goal_name
                    },
                    {
                        tag: 'td',
                        block: self.__self.getName(),
                        elem: 'td',
                        cls: 'b-table__td',
                        content: '&nbsp;'
                    },
                    {
                        tag: 'td',
                        cls: 'b-table__td',
                        block: self.__self.getName(),
                        elem: 'td',
                        content: {
                            tag: 'select',
                            block: self.__self.getName(),
                            elem: 'select',
                            content: content
                        }
                    }
                ]
            }))
        });
        //кэшируем строки
        this.elem('tr');
    },

    cancel: function() {
        this.popup.hide();
    },

    save: function() {
        var _this = this;
        var data = $.map(this.elem('tr'), function(tr) {
            var id = _this.getMod($(tr), 'id'),
                select = _this.findElem($(tr), 'select');
            return  {old_goal_id : id, new_goal_id : select.val()}
        });
        BEM.blocks['i-get-goals-ajax'].replaceGoals(data, this.params.ulogin, $.proxy(this.onSuccess, this), $.proxy(this.onError, this));

    },

    onSuccess: function() {
        this.popup.hide();
    },

    onError: function(text) {
        this.elem('error').html(text)
    }
}, {


    getInstance: function() {
        return this.instance;
    }
});

})(jQuery);