(function($, Lego) { 
    
Lego.block['b-report-order'] = function(params) {
    var $this = $(this),
        typeInputs = $('.b-report-order__type .b-report-order__input', $this),
        campaign = $('.b-report-order__campaign', $this),
        period = $('.b-report-order__period', $this),
        grouping = $('.b-report-order__grouping', $this),
        groupingRow = grouping.parents('tr:eq(0)'),
        submit = $('.b-report-order__submit', $this),
        errors = $('.b-report-order__errors', $this),
        grouping_checkbox = $('.b-report-order__grouping__checkbox', $this),
        platformTypeInput = $('.b-report-order__platform-type',$this),
        showPhrasesCheckbox = $('.b-report-order__phrases',$this);

    $(document).ready(function() {
        typeInputs.filter('[value=' + params.startValue + ']').prop('checked', true);
        onInputClick(params.startValue);
    });

    typeInputs.click(function() {
        onInputClick(this.value);
    });

    grouping_checkbox.change(function(){
        grouping.prop('disabled',!$(this).prop('checked'));
    });


    submit.click(function(e) {
        var data = {
            cids: campaign.data('api').selectedCids().join(','),
            grouping: grouping.prop('disabled') ? '' : grouping.val(),
            type: typeInputs.filter(':checked').val(),
            date_from: period.data('api').dates().from ? format(period.data('api').dates().from) : '',
            date_to: period.data('api').dates().to ? format(period.data('api').dates().to) : '' ,
            platform_type: platformTypeInput.val(),
            show_phrases: showPhrasesCheckbox.filter(':checked').val()
        };
        if (!data.cids) {
            alert(iget('Выберите кампании'));
            return;
        }
        
        submit.prop('disabled', true);
        errors.hide();
        
        $.ajax({
            url: SCRIPT,
            type: 'POST',
            data: $.extend(data, {
                cmd: 'addPdfReport',
                ulogin: window.ulogin
            }),
            complete: onSubmitSuccess
        });
    });

    function onInputClick(value) {
        campaign.data('api').isSingle(value == 'bm');
        groupingRow.toggleClass('hidden', value == 'bm');
        if (value == 'bm') grouping.prop('selectedIndex', 0);
    }
    
    function onSubmitSuccess (xhr, status) {
        
        submit.prop('disabled', false);
       
        var result;
        try {
            result = eval('(' + xhr.responseText + ')');
        } catch(e) {
        }
        if (!result || status != 'success') {
            alert(iget('Ошибка при выполнении запроса. Перезагрузите страницу и попробуйте еще раз.'));
            return;
        }
            
        if (result.errors) {
            errors.text(result.errors.join('<br />')).show();
        } else {
            $('.b-report-ready').data('api').reload();
            $('.b-tabs:eq(0)').data('api').selectedIndex(1);
            document.body.scrollTop = 0;
        }
    }
    
    function format(date) {
        return zeroFill(date.getDate()) + '-' +  zeroFill(date.getMonth() + 1) + '-' + date.getFullYear();
    }
    
    function zeroFill(value)
    {
        return (value < 10 ? '0' : '') + value;
    }
    
};
})(jQuery, window.Lego);
