(function($, Lego) { 
    
Lego.block['b-report-order__campaign'] = function(params) {
    var $this = $(this),
        isSingle = params.isSingle || false,
        actions = $this.nextAll('.b-report-order__campaign__action:eq(0)'),
        search  = $('.b-report-order__campaign__search__input', actions),
        searchContainer = search.parents('.b-input:eq(0)'),
        selectAll = $('.b-report-order__campaign__select-all', actions),
        clear = $('.b-report-order__campaign__action__clear', actions),
        items   = $('.b-report-order__campaign__item', $this),
        searchable = $('.b-report-order__campaign__searchable', $this),
        hiddenIndexes = [],
        searchIndex = [],
        originalHTML = [],
        lastQuery = '',
        allSelected = false;
        
    searchable.each(function() {
        searchIndex.push(this.innerHTML.toLowerCase());
        originalHTML.push(this.innerHTML);
    });
    
    $this.data('api', {
        hiddenIndexes: function(indexes, hlt) {
            if (indexes === undefined) return hiddenIndexes;
            
            hiddenIndexes = indexes;
            var k = 0;
            items.each(function(i) {
                if (k < hiddenIndexes.length && i == hiddenIndexes[k]) {
                    this.style.display = 'none';
                    k++;
                } else {
                    this.style.display = '';
                    searchable[i].innerHTML = hlt ? originalHTML[i].replace(hlt, '<span class="b-report-order__campaign__hlted">$1</span>') : originalHTML[i];
                }
            });
            return this;
        },
        
        selectedIndexes: function(indexes) {
            if (indexes === undefined) {
                var result = [];
                $('input', $this).each(function(i) {
                    if (this.checked) result.push(i);
                });
                return result;
            }
            
            var k = 0;
            $('input', $this).each(function(i) {
                if (k < indexes.length && indexes[k] == i) {
                    this.checked = true;
                    k++; if (isSingle) return false;
                } else {
                    this.checked = false;
                }
            });
            recalcSelectAll();
            return this;
        },
        
        // readonly
        selectedCids: function() {
            var result = [];
            $('input', $this).each(function(i) {
                if (this.checked) result.push(this.value);
            });
            return result;
        },
        
        selectAll: function() {
            if (isSingle) return;
            $('input', $this).prop('checked', true);
            recalcSelectAll();
        },
        
        clear: function() {
            if (isSingle) return;
            $('input', $this).prop('checked', false);
            recalcSelectAll();
        },
        
        isSingle: function(state) {
            if (state === undefined) return isSingle;
            
            isSingle = state;
            var type = isSingle ? 'radio' : 'checkbox',
                indexes = this.selectedIndexes();
                
            $('input', $this).each(function() {
                var html = '<input class="b-report-order__input"';
                html += ' value="' +  direct.utils.escapeHTML(this.value) + '"';
                html += ' type="' + type + '"';
                html += ' name="' + this.name + '"';
                html += ' id="' + this.id + '" />';
                
                $(this).replaceWith($(html));
            });
            
            this.selectedIndexes(indexes);
            selectAll.toggleClass('b-report-order__campaign__select-all_disabled', !!isSingle);
            recalcSelectAll();
            return this;
        }
    });
    
    function recalcSelectAll () {
        allSelected = isSingle || !$('input:not(:checked)', $this).length;
        selectAll.html('<span>' + (allSelected ? iget('очистить') : iget('выбрать все')) + '</span>');
    }
    
    var api = $this.data('api');
    
    $this.click(function(e) {
        if (e.target.tagName == 'INPUT') recalcSelectAll();
    })
    
    selectAll.click(function() {
        allSelected ? api.clear() : api.selectAll();
    });
    
    clear.click(function() {
        search.val('').trigger('change');
    });
        
    search.bind('click change keyup', function() {
        var q = $.trim(this.value).toLowerCase(),
            hiddenIndexes = [];
        if (q == lastQuery) return;
        lastQuery = q;
        searchContainer.toggleClass('b-report-order__campaign__action_showclear', !!q);
        if (q) {
            var parts = q.split(/\s+/),
                hltParts = $.map(parts, function(part) { return part.replace(/(.)/g, '[$1]'); });
            var hlt = new RegExp('(' + hltParts.join('|') + ')', 'ig');

            for (var i=0; i < searchIndex.length; i++) {
                for (var j=0; j < parts.length; j++) {
                    if (searchIndex[i].indexOf(parts[j]) == -1) {
                        hiddenIndexes.push(i);
                        break;
                    }
                };
            };
            api.hiddenIndexes(hiddenIndexes, hlt);
        } else {
            api.hiddenIndexes([], null);
        }
    }).trigger('change');
    
    recalcSelectAll();
};
})(jQuery, window.Lego);
