include('../../../js/jq/direct/dateRanges.js');

(function($, Lego) { 
    
var DEFAULT_RANGE = 'last7days';
    
Lego.block['b-report-order__period'] = function(params) {
    var $this = $(this),
    
        dateFrom = params.from ? string2date(params.from) : direct.DateRanges.getRange(DEFAULT_RANGE).from,
        dateTo = params.to ? string2date(params.to) : direct.DateRanges.getRange(DEFAULT_RANGE).to,
        
        calendarFrom = $('.b-report-order__period__calendar-from', $this),
        calendarTo = $('.b-report-order__period__calendar-to', $this),
        
        cliteFrom = new clite(),
        cliteTo = new clite(),
        
        radios = $('.b-report-order__input', $this);
        
    cliteFrom.appendToPlace(calendarFrom[0]);
    cliteTo.appendToPlace(calendarTo[0]);
    
    $this.data('api', {
        dates: function() {
            return { from: dateFrom, to: dateTo };
        }
    });
    
    var calendarInputs = $('.calendar-input', $this),
        calendarButtons = $('.calendar-button', $this);
        
    
    radios.click(function() {
        if (!isCustomSelected()) {
            var range = direct.DateRanges.getRange(this.value);
            dateFrom = range.from;
            dateTo = range.to;
            if (this.value == 'last100years')
            {
                dateFrom = dateTo = false;
            }
        }
        
        updateClite();
    });
    
    restoreState();
    
    calendarInputs.change(function() {
        radios[radios.length - 1].checked = true;
        dateFrom = cliteFrom.empty ? false : cliteFrom.date;
        dateTo = cliteTo.empty ? false : cliteTo.date;
    });
    
    function restoreState () {
        var range = direct.DateRanges.getRangeName(dateFrom, dateTo),
            selected;
            
        radios[radios.length - 1].checked = true;
        
        if (range) {
            selected = radios.filter('[value=' + range + ']');
            if (selected.length) selected.prop('checked', true);
        }
        cliteFrom.date = dateFrom;
        cliteTo.date = dateTo;
        cliteTo.empty = cliteFrom.empty = false;
        cliteTo.update();
        cliteFrom.update();
        

        updateClite();

    }
    
    function updateClite () {
        if (isCustomSelected()) {
            cliteTo.update();
            cliteFrom.update();
        }
        // calendarToInput.attr('disabled', !custom);
        // calendarFromInput.attr('disabled', !custom);
        // calendarToButton.attr('disabled', !custom);
        // calendarFromButton.attr('disabled', !custom);
    }
    
    function isCustomSelected () {
        return radios[radios.length - 1].checked;
    }
};
})(jQuery, window.Lego);
