(function($){
/*
 * 'mode':
 *      'edit' - просмотр, редактирование
 *      'view' - только просмотр
 *      'mediaplaner' - может смотреть и выбирать из существующих условий, но не может редактировать условия и создавать новые
 */

BEM.DOM.decl('b-retargeting-condition-controls', {
    onSetMod: {
        'js': function(){
            var self = this;
            self.goals = BEM.blocks['i-get-goals-ajax'].getGoals();
            self.isEmpty = !this.goals || !this.goals.length;
            self.setMod('empty', self.isEmpty ? 'yes' : 'no');
            if (self.isEmpty) { return; }

            self.newBtn = self.findBlockOn('new', 'b-form-button');
            self.newBtn && self.newBtn.on('click', self.saveNew, self);
            self.cancelBtn = self.findBlockOn('cancel', 'b-form-button').on('click', self.cancel, self);
            self.saveBtn = self.findBlockOn('save', 'b-form-button').on('click', self.save, self);
        },
        'mode': function(modName, modVal) {
            this.condition && this.condition.setMod('mode', modVal)
        }
    },


    cancel: function() {
        this.trigger('cancel')
    },

    save: function() {
        if (!this.validate()) return;
        this.saveBtn.setMod('disabled', 'yes');
        this.doEdit(this.condition.getData(), 0, function() {
            this.saveBtn.setMod('disabled', 'no');
        });
    },

    validate: function() {
        var data = this.condition.getData(),
            hasReached = false;

        $.each(data.condition, function(i, cond) {
            if (cond.type != 'not') hasReached = true;
            if (hasReached) { return false; }
        });

        if (hasReached) {
            this.elem('error').html('');
            return true;
        } else {
            this.elem('error').html(iget('В условии должна присутствовать хотя бы одна выполненная цель'));
            this.trigger('error');
            return false;
        }
    },

    onConditionChange: function() {
        this.elem('error').html('');
        this.adjustDisabled();
    },

    saveNew: function() {
        var data = this.condition.getData();
        delete data.ret_cond_id;
        this.newBtn.setMod('disabled', 'yes');
        this.doEdit(data, 1, function() {
            this.newBtn.setMod('disabled', 'no');
        });
    },

    doEdit: function(data, isNew, callback) {
        var _this = this;
        BEM.blocks['i-retargeting-conditions'].edit(data,
            function(cond) {
                _this.elem('error').html('');
                isNew ? _this.trigger('save-new', cond) : _this.trigger('save', cond);
                $.isFunction(callback) && callback.call(_this);
            },
            function(error) {
                _this.elem('error').html(error.error_text);
                _this.trigger('error', error);
                $.isFunction(callback) && callback.call(_this);
            }
        );
    },


    setCondition: function(condition) {
        if (this.isEmpty) { return; }

        var _this = this;

        this.elem('error').html('');
        this.elem('condition').html(BEM.HTML.build({
            block: 'b-retargeting-condition',
            id: condition.ret_cond_id,
            comment: condition.condition_desc,
            name: condition.condition_name,
            condition: condition.condition
        }));

        this.condition = this.findBlockInside('b-retargeting-condition')
            .on('change', this.onConditionChange, this)
            .bindTo('add-group', 'click', function() {
                _this.elem('error').text('');
            });

        if (this.condition.noGoals()) {
            this.setMod('empty', 'yes')
        }

        this.condition.setMod('mode', this.getMod('mode'));
        this.adjustDisabled();

    },

    adjustDisabled: function() {
        this.newBtn && this.newBtn.setMod('disabled', this.condition.isChanged() ? 'no' : 'yes');
        this.saveBtn.setMod('disabled', this.condition.isEmpty() ? 'yes' : 'no');
    }
}, {
    live: true
});

})(jQuery);
