(function($){

BEM.DOM.decl('b-retargeting-condition-popup', {
    onSetMod: {
        'js': function(){
            this.__self.instance = this;
            var _this = this;

            this.onGoalsLoaded();

            this.controls = this.findBlockInside('b-retargeting-condition-controls')
                .on('cancel save', function () {
                    _this.popup.hide();
                })
                .on('save-new', this.onSaveNew, this);

            this.popup = this.findBlockOn('popup', 'b-popupa').on('outside-click', function(e) {
                e.preventDefault();
            }, this);
        }
    },

    onGoalsLoaded: function() {
        this.goals = BEM.blocks['i-get-goals-ajax'].getGoals();

        var isEmpty = !this.goals || !this.goals.length;
        this.setMod(this.elem('popup'), 'empty', isEmpty ? 'yes' : 'no');
    },

    onSaveNew: function() {
        this.popup.hide();
        this.trigger('save-new');
    },

    toggle: function(elem, condition) {
        this.controls.setCondition(condition);
        this.popup.toggle(elem)
    }
}, {

    live: true,
    getInstance: function(options) {
        if (!this.instance) {
            $('#b-retargeting-condition-popup').bem('b-retargeting-condition-popup');
        }
        options = options || {};
        this.instance.controls.setMod('mode', options.mode);
        return this.instance;
    }
});

})(jQuery);