(function($){

BEM.DOM.decl('b-retargeting-condition', {
    onSetMod: {
        'js': function(){
            this.init();
        },

        'mode': function(modName, modVal){
            if (!this.goals || !this.goals.length) { return; }
            this.setDisabled(modVal == 'view' || modVal == 'mediaplaner');
        }
    },

    init: function() {

        this.groupNum = 0;
        this.goals = BEM.blocks['i-get-goals-ajax'].getGoals();
        if (!this.goals || !this.goals.length) { return; }




        this.name = this.findBlockOn(this.elem('name'), 'b-form-input')
            .on('change', this.onNameChange, this);
        this.comment = this.findBlockOn(this.elem('comment'), 'b-form-input');

        BEM.blocks['b-condition-group'].on('delete-group', this.onDeleteGroup, this);

        this
            .bindTo('add-comment', 'click', function() {
                this.setMod('comment', 'show')
            })
            .bindTo('del-comment', 'click', function() {
                this
                    .setMod('comment', 'hide')
                    .comment.val('');
            })
            .bindTo('add-group', 'click', this.addGroup);

        this.refreshGroups(1);
        this.setDisabled(this.getMod('mode') == 'view' || this.getMod('mode') == 'mediaplaner')
    },

    setDisabled: function(disabled) {
        this.setMod('disabled', disabled ? 'yes' : 'no');
        this.name.setMod('disabled', disabled ? 'yes' : 'no');
        this.comment.setMod('disabled', disabled ? 'yes' : 'no');
        $.each(this.groups, function(i, group) {
            group.setDisabled(disabled)
        });
    },


    onNameChange: function() {
        this.nameChanged = true;
        this.trigger('change')
    },

    onGroupChange: function() {
        this.groupChanged = true;
        this.trigger('change')
    },

    isChanged: function() {
        return this.groupChanged && this.nameChanged;
    },

    noGoals: function() {
        return !this.goals || !this.goals.length;
    },

    isEmpty: function() {
        if (!this.name) { return true; }
        var name = $.trim(this.name.val());
        return this.groupNum == 0 || !name;
    },


    getData: function() {
        return {
            condition_name: this.getName(),
            condition_desc: this.getComment(),
            condition: this.getRules(),
            ret_cond_id: this.params.id
        }
    },

    getName: function() {
        return this.name.val();
    },

    getComment: function() {
        return this.getMod('comment') ==  'hide' ? '' : this.comment.val();
    },

    clear: function() {
         this.elem('groups').empty();
         this.name.val('');
         this.comment.val('');
         this.setMod('comment', 'hide')
    },

    getRules: function() {
        var rules = [];
        this.groups && $.each(this.groups, function(i, group) {
            rules.push(group.getData())
        });
        return rules;
    },

    addGroup: function() {
        this.elem('groups').append(
            BEM.HTML.build({
                block: 'b-condition-group',
                id: this.groupNum + 1

            }));
        this.refreshGroups();
    },

    onDeleteGroup: function() {
        this.refreshGroups();
    },

    refreshGroups: function(isInit) {
        this.groups = this.findBlocksInside('b-condition-group');
        var self = this;
        this.groupNum = this.groups.length;
        $.each(this.groups, function(i, group) {
            group.setOne(self.groupNum == 1);

            group.on('change', self.onGroupChange, self);
            group.setLast(i == self.groupNum - 1);
            group.setNum(i + 1)
        });

        this.setMod('max', MAX_RETARGETING_GROUPS == this.groupNum ? 'yes' : 'no');
        !isInit && this.onGroupChange();
    }
});

BEM.HTML.decl('b-retargeting-condition', {
    onBlock: function(ctx){
        var goals = BEM.blocks['i-get-goals-ajax'].getGoals();
        ctx
            .js({'id': ctx.param('id')})
            .mods({'comment' : ctx.param('comment') ? 'show' : 'hide'})
            .content([
            { elem: 'name-block', name: ctx.param('name'), comment: ctx.param('comment')},
            { elem: 'groups-title', content: iget('Показывать объявления если:')},
            {
                elem: 'groups-block',
                condition: ctx.param('condition')
            }
        ])


    },

    onElem: {
        'name-block': function(ctx) {
            var elemCls = 'b-retargeting-condition__elem';
            ctx
                .content([
                    { cls: elemCls,  elem: 'label', tag: 'span', content: iget('Название') + ':'},
                    {
                        block: 'b-form-input',

                        value: ctx.param('name') ,
                        cls: elemCls,
                        mix: [{block: 'b-retargeting-condition', elem: 'name'}]
                    },
                    { cls: 'b-pseudo-link ' + elemCls, tag: 'span', content: iget('примечание'), elem: 'add-comment'},
                    {
                        tag: 'span',
                        elem: 'comment-block',
                        content: [
                            { elem: 'label', cls: elemCls, tag: 'span', content: iget('Примечание') + ':'},
                            {
                                block: 'b-form-input',
                                value: ctx.param('comment'),
                                cls: elemCls,
                                mix: [{block: 'b-retargeting-condition', elem: 'comment'}]
                            },
                            { elem: 'del-comment', cls: elemCls}
                        ]
                    }
                ])
        },
        'groups-block': function(ctx) {
            var condition  = ctx.param('condition'),
                groups = [],
                goals = BEM.blocks['i-get-goals-ajax'].getGoals();

            condition && $.each(condition, function(i, cond) {
                groups.push({
                    block: 'b-condition-group',
                    id: i + 1,
                    type: cond.type,
                    goals: cond.goals
                });
            });

            //Если нет групп, то по умолчанию добавляем одну пустую
            if (groups.length == 0) {
                groups.push({
                    block: 'b-condition-group',
                    id: 1,
                    type: 'or'
                });
            }

            ctx.content([
                {
                    elem: 'groups',
                    tag: 'div',
                    content: groups
                },
                {
                    elem: 'add-group-block',
                    content: {
                        tag: 'span',
                        content: iget('добавить группу'),
                        elem: 'add-group',
                        cls: 'b-pseudo-link'
                    }
                }
            ])
        }
    }


});

})(jQuery);
