(function($){

    BEM.DOM.decl({ name : 'b-retargeting-conditions-list', modName : 'mode', modVal : 'list' }, {
        onSetMod: {
            'js': function(){
                this.rebuildConditionsHash();

                BEM.channel('i-retargeting-conditions').on('change', this.onConditionChange, this);
                BEM.channel('i-retargeting-conditions').on('delete', this.onConditionDelete, this);
            }
        } ,

        onConditionDelete: function(e, id) {
            var idsArr = id.split(',');
            for (var i = 0; i < idsArr.length; i++) {
                var id = idsArr[i]
                if (this.conditionsHash[id]) {
                    this.conditionsHash[id].domElem.remove();
                }
            }
            this.rebuildConditionsHash();

            this.setMod('empty', this.conditions.length > 0 ? 'no' : 'yes');
            BEM.blocks['b-checkboxes-group'].trigger('refresh');
        },

        rebuildConditionsHash: function() {
            var _this = this;
            this.conditionsHash = {};
            this.conditions = this.findBlocksInside('b-retargeting-conditions-tr');
            $.each(this.conditions, function(i, cond) {
                _this.conditionsHash[cond.getId()] = cond;
                cond.setNum(i + 1);
            });

            BEM.blocks['b-checkboxes-group'].trigger('refresh');
        },


        onConditionChange: function(e, data) {
            if (this.conditionsHash[data.ret_cond_id]) {
                this.conditionsHash[data.ret_cond_id].reset(data);
                return;
            }

            this.elem('tbody').append(BEM.HTML.build({
                block:'b-retargeting-conditions-tr',
                condition:data,
                num:data.num,
                mode:this.getMod('mode'),
                mods:{mode:this.getMod('mode')}
            }));
            this.rebuildConditionsHash();

            this.findBlockInside('b-checkboxes-group').allCbx.setMod('checked', 'no')

            this.setMod('empty', this.conditions.length > 0 ? 'no' : 'yes');
        }
    });

})(jQuery);
