(function($){


    BEM.DOM.decl({ name : 'b-retargeting-conditions-tr', modName : 'mode', modVal : 'list' }, {
        onSetMod: {
            'js': function(){
                this.__self.liveBindTo('name', 'click', this.onEditClick);
                this.__self.liveBindTo('del', 'click', this.onDeleteClick);
                this.__base();
            }
        },


        reset: function(data) {
            var name = data.condition_name.length > 40 ? data.condition_name.substr(0, 40) + '...' :data.condition_name
            this.elem('name').html(direct.utils.escapeHTML(name));
            this.elem('desc').html(direct.utils.escapeHTML(data.condition_desc));
            this.elem('desc').toggleClass(data.condition_desc, 'b-table__td_center_no', 'b-table__td_center_yes')
        },

        getConditionParams: function() {
            return BEM.blocks['i-retargeting-conditions'].get(this.getId())
        },

        onDeleteClick: function() {
            if (confirm(iget('Вы уверены, что хотите удалить выбранные условия?'))) {
                BEM.blocks['i-retargeting-conditions'].deleteCondition(this.getId())
            }

        },

        getPopup: function() {
            return this.popup || (this.popup = BEM.blocks['b-retargeting-condition-popup'].getInstance({mode: 'edit'}));
        },

        onEditClick: function() {
            BEM.blocks['b-get-goals-ajax'].loadGoals(function() {
                this.getPopup().toggle(this.elem('name'), this.getConditionParams());
            }, this.elem('edit').parent(), this)
        }
    });

})(jQuery);
