(function($){
    BEM.DOM.decl('b-retargeting-conditions-tr', {
        onSetMod: {
            'js': function() {
                BEM.blocks['b-get-goals-ajax'].loadGoals(function() {
                    var id = this.getId(),
                        condition = BEM.blocks['i-retargeting-conditions'].get(id),
                        domains = [];

                    $.each(condition.condition, function(i, cond) {
                        $.each(cond.goals, function(i, goal){

                            var goalData = BEM.blocks['i-get-goals-ajax'].getGoalById(goal.goal_id) || {},
                                domain = goalData.goal_domain;

                            $.inArray(domain, domains) == -1 && domains.push(domain);
                        })
                    });
                    this.fillDomain(domains.join(', '));

                }, this.elem('domain'), this);

            }
        },

        fillDomain: function(domains) {
            this.elem('domain').html(domains || '&mdash;')
            this.setMod(this.elem('domain'), 'empty', domains ? 'no' : 'yes');
        },

        setNum: function(num) {
            this.elem('num').html(num);
        },


        getId: function() {
            return this.getMod('id');
        }
    },
    {
        live: true
    });

    BEM.HTML.decl('b-retargeting-conditions-tr', {
        onBlock: function(ctx){
            var condition = ctx.param('condition');
            ctx
                .js(true)
                .mods({id: condition.ret_cond_id, 'mode' : ctx.param('mode')})
                .tag('tr')
                .mix([{block: 'b-table', elem: 'tr'}])
                .content([
                {
                    tag: 'td',
                    elem: 'cbx',
                    cls: 'b-table__cbx',
                    mix: [{block: 'b-table', elem: 'td'}],
                    content: {
                        block: 'b-checkboxes-group',
                        elem: 'cbx',
                        mods: {val: condition.ret_cond_id, all: 'no'},
                        content: {
                            block: 'b-form-checkbox',
                            js: true
                        }
                    }
                },
                {
                    tag: 'td',
                    mix: [{block: 'b-table', elem: 'td'}],
                    elem: 'num',
                    cls: 'b-table__num',
                    content: ctx.param('num')
                },
                {
                    tag: 'td',
                    mix: [{block: 'b-table', elem: 'td'}],
                    cls: 'b-table__name',
                    elem: 'td',
                    content: ctx.param('mode') == 'list' ? [
                        {
                            elem: 'name',
                            tag: 'span',
                            cls: 'b-table__h3 b-pseudo-link',
                            content: direct.utils.escapeHTML(condition.condition_name.length > 40 ? condition.condition_name.substr(0, 40) + '...' : condition.condition_name)
                        },
                        !condition.is_used_in_banner && {
                            elem: 'del',
                            tag: 'div'
                        }
                    ] : {
                        elem: 'name',
                        content: direct.utils.escapeHTML(condition.condition_name.length > 40 ? condition.condition_name.substr(0, 40) + '...' :condition.condition_name)

                    }
                },
                {
                    tag: 'td',
                    cls: 'b-table__settings',
                    mix: [{block: 'b-table', elem: 'td'}],
                    elem: 'td',
                    content: {
                        elem: 'domain',
                        mods: {'empty': 'yes'},
                        content: '&mdash;'
                    }
                },
                ctx.param('mode') == 'list' && {
                    tag: 'td',
                    cls: 'b-table__settings b-retargeting-conditions-tr__campaigns-td',
                    mix: [{block: 'b-table', elem: 'td'}],
                    elem: 'td',
                    content: {
                        elem: 'campaigns',
                        mods: {'empty': 'yes'},
                        content: '&mdash;'
                    }
                },
                {
                    tag: 'td',
                    mix: [{block: 'b-table', elem: 'td', mods: {'center': (condition.condition_desc ? 'no' : 'yes')}}],
                    elem: 'desc',
                    cls: 'b-table__settings',
                    content: (direct.utils.escapeHTML(condition.condition_desc) || '&mdash;')
                },
                // DIRECT-23253: Медиапланеру доступна кнопка редактирования условий ретаргетинга в медиаплане и ПП
                ctx.param('hasEditRight') && ctx.param('mode') == 'popup' && {
                    tag: 'td',
                    mix: [{block: 'b-table', elem: 'td'}],
                    elem: 'edit',
                    content: {
                        tag: 'img',
                        elem: 'edit-img',
                        attrs: {src: '/i/edit_pen.png'}

                    }

                },
                ctx.param('mode') == 'list' && {
                    tag: 'td',
                    elem: 'shows',
                    content: 0,
                    cls: 'b-table__numeric',
                    mix: [{block: 'b-table', elem: 'td'}]
                },
                ctx.param('mode') == 'list' && {
                    tag: 'td',
                    elem: 'clicks',
                    content: 0,
                    cls: 'b-table__numeric',
                    mix: [{block: 'b-table', elem: 'td'}]
                },
                ctx.param('mode') == 'list' && {
                    tag: 'td',
                    elem: 'ctr',
                    content: '0.00',
                    cls: 'b-table__numeric',
                    mix: [{block: 'b-table', elem: 'td'}]
                }
            ])
        }


    });

})(jQuery);
