(function($){

BEM.DOM.decl('b-retargeting-error-warning', {
    onSetMod: {
        'js': function(){
            //кэшируем внутренности попапа
            this.elem('action');
            this.popup = this.findBlockInside('b-popupa');
            this.cancel = this.findBlockOn('cancel', 'b-form-button').on('click', this.cancel, this);
            this.ok = this.findBlockOn('ok', 'b-form-button').on('click', this.doAction, this);
        }
    },

    editCondition: function() {
        this.popup.hide();
        BEM.blocks['b-retargeting-condition-popup'].getInstance({mode: 'edit'})
            .toggle(this.elem('link'), BEM.blocks['i-retargeting-conditions'].get(this.getMod('id')));

    },

    replaceGoals: function() {
        this.popup.hide();
        BEM.blocks['b-replace-goals'].getInstance().toggle(this.stopGoals);
    },

    switchCondition: function() {
        var _this = this;
        BEM.blocks['i-retargeting-conditions'].switchCondition([this.getMod('id')], 1, function() {
            _this.popup.hide();
        });
    },

    doAction: function() {
        switch (this.elem('action').val()) {
            case 'edit':
                this.editCondition();
                return;
            case 'replace':
                this.replaceGoals();
                return;
            case 'stop':
                this.switchCondition();
                return;
            default:
                return;

        }

    },

    cancel: function() {
        this.popup.hide();
    },

    setPopupContent: function() {
        var condition = BEM.blocks['i-retargeting-conditions'].get(this.getMod('id')),
            goalsIds = [];

        $.each(condition.condition, function(i, cond) {
            $.each(cond.goals, function(j, goal) {
                goalsIds.push(goal.goal_id)
            })
        });

        this.stopGoals =  BEM.blocks['i-get-goals-ajax'].getNotAllowedGoals(goalsIds);
        var text = [];

        $.map(this.stopGoals, function(goal) {
            text.push(goal.goal_domain + '::' + goal.goal_name)
        })
        this.elem('goals').html(text.join(', '))
    },

    toggle: function() {

        this.setPopupContent();
        this.popup.toggle(this.elem('link'));
    }
}, {
    live: function(){
        this.liveBindTo('link', 'click', function() {
            this.toggle();
        })
    }
});

})(jQuery);
