(function($){

BEM.DOM.decl('b-retargeting-group-actions', {
    onSetMod: {
        'js': function(){
            var _this = this;

            this.checkboxes = this.findBlockInside('b-checkboxes-group')
                .on('change', this.onSelectionChange, this);

            // сохраняем список пунктов селекта, потом будем их вынимать/вставлять
            this.selectOptions = $.map(['empty', 'del', 'disabled'], function(el) {
                return [[el, _this.elem(el)]];
            });

            this.ok = this.findBlockOn(this.elem('ok'), 'b-form-button').on('click', $.proxy(this.doAction, this)) ;

            this.onSelectionChange();
        }
    },



    onSelectionChange: function() {
        this.setMod('empty', this.checkboxes.isEmpty() ? 'yes' : 'no');

        var selected = this.checkboxes.getChecked(),
            canDelete = false,
            disabled,
            select = this.elem('select');

        $.each(selected, function(i, id) {
            var cond = BEM.blocks['i-retargeting-conditions'].get(id);

            if (!cond.is_used_in_banner) {
                canDelete = true;
                return false;
            }
        });

        disabled = !(selected.length && canDelete);

        this.ok.setMod('disabled', disabled ? 'yes' : '');

        // вынимаем из DOM-а пункты селекта групповых действий
        this.elem('select-option').detach();

        // вставляем обратно только те, которые можно использовать
        $.each(this.selectOptions, function(i, el) {
            if (canDelete ? el[0] == 'del' : el[0] != 'del')
                select.append(el[1]);
        });

        select
            .prop('disabled', disabled)
            .val(!selected.length ? 'disabled' : canDelete ? 'del' : 'empty');

    },


    deleteSelected: function() {
        var selected = this.checkboxes.getChecked(),
            toDelete = [],
            confirmText = '';

        $.each(selected, function(i, id) {
            var cond = BEM.blocks['i-retargeting-conditions'].get(id);

            if (cond.is_used_in_banner) {
                confirmText += iget('Условие %s используется и не может быть удалено.', cond.condition_name) + '\n';
            } else {
                toDelete.push(cond.ret_cond_id)
            }
        });

        if (!confirmText || confirm(confirmText)) {
            if (confirm(iget('Вы уверены, что хотите удалить выбранные условия?'))) {
                BEM.blocks['i-retargeting-conditions'].deleteCondition(toDelete.join(','));
            }
        }

    },

    doAction: function() {
        var action = this.elem('select').val();

        switch (action) {
            case 'del':
                this.deleteSelected();
                return;
            default:
                return;
        }

    }
});

})(jQuery);
