(function($) {
     BEM.DOM.decl({name:'b-retargeting-window'}, {
         onSetMod : {
             js: function() {
                 this.modelName = this.params.modelName || 'b-banner-edit';
                 this.init();
             }
         },

         init: function() {
             this.popupaElem = this.elem('popup');
             var _this = this;
             this.goals = BEM.blocks['i-get-goals-ajax'].getGoals();
             if (this.goals && this.goals.length > 0) {
                 this.delMod(this.elem('popup'), 'conditions');
             }

             this.__self.instance = this;

             this.tabbedPane = this.findBlockInside('b-tabbed-pane')
                 .on('current', this.onSwitchPane, this);

             this.newCond = this.findBlockInside(this.elem('new-block'), 'b-retargeting-condition-controls');
             this.newCond && this.newCond
                 .on('save', this.onNewCondSave, this)
                 .on('cancel', this.hide, this);
             this.savedCond = this.findBlockInside('b-conditions-saved');
             this.editCond = this.findBlockInside(this.elem('edit-block'), 'b-retargeting-condition-controls')
                 .on('save save-new', function() {
                     _this.switchAction('list');
                 }, this)
                 .on('cancel', function() {
                     _this.switchAction('list');
                 }, this);

             var isEmpty = !this.goals || !this.goals.length;

             this.setMod(this.popupaElem, 'empty', isEmpty ? 'yes' : 'no');
         },

         onNewCondSave: function(e, response) {
             this.hide();
             var model = BEM.blocks['i-models-manager'].get('campaign&banner:' + this.getParam('bid'), this.modelName);
             model.update({
                 'retargeting_conditions_id': BEM.blocks['i-banner-edit'].addIdToString(response.ret_cond_id, model.get('retargeting_conditions_id'))
             }, this);
         },


         onSwitchPane: function(e, data) {
             var action = this.tabbedPane.getMod(data.current, 'action');

             this.switchAction(action, this.tabbedPane);
         },

         initConditionById: function(id) {
             this.editCond.setCondition(BEM.blocks['i-retargeting-conditions'].get(id));
         },

         getPopup: function() {
             return (this._popup || (this._popup = this.findBlockInside('b-popupa')))
                 .on('outside-click', function(e) {
                     e.preventDefault();
                 }, this);
         },

         getParams: function() {
             return this.params || {};
         },

         getParam: function(id) {
             return (this.getParams() || {})[id];
         },

         toggle: function(owner, params) {
             if (!this.goals || !this.goals.length) {
                 this.getPopup().toggle(owner);
             } else {
                 this.params = params;
                 if (this.newCond) {
                     this.switchAction('new');
                     this.newCond.setCondition({});
                 } else {
                     this.savedCond.buildConditions();
                 }

                 this.getPopup().toggle(owner);
             }
             return this;

         },

         hide: function() {
             this.getPopup().hide();
             return this;
         },

         addParam: function(id, val) {
             this.params[id] = val;
         },



         switchAction: function(action, source) {
             this.setMod(this.popupaElem, 'action', action);

             if (source != this.tabbedPane) {
                this.tabbedPane.selectByIndex($.inArray(action, ['new', 'list']));
             }

             if (action == 'list') { this.savedCond.buildConditions(); }

             return this;
         }
     }, {

        getInstance: function() {
            if (!this.instance) {
                this.instance = $('#b-retargeting-window').bem('b-retargeting-window');
            }
            return this.instance;
        },
        live: true
     })

})(jQuery);
