include('../../js/jq/direct/utils.js');

(function($, Lego) {
    Lego.block['b-search-client-id'] = function(params) {
        var $this = $(this),
            fields = [
                {
                    field: $('.b-search-client-id__name', $this),
                    isValid: function() {
                        return !!this.field.val();
                    },
                    error: iget('название')
                },
                {
                    field: $('.b-choose-country__country-hidden', $this),
                    isValid: function() {
                        return !!this.field.val();
                    },
                    error: iget('страну')
                },
                {
                    field: $('.b-choose-currency__currency-hidden', $this),
                    isValid: function() {
                        return !!this.field.val();
                    },
                    error: iget('валюту')
                },
                {
                    field: $('.b-search-client-id__phone', $this),
                    isValid: function() {
                        return (this.field.val().match(/\d/g) || []).length >= 2;
                    },
                    error: iget('корректный телефон')
                },
                {
                    field: $('.b-search-client-id__url', $this),
                    isValid: function() {
                        return true;
                    },
                    error: iget('веб-сайт')
                },
                {
                    field: $('.b-search-client-id__email', $this),
                    isValid: function() {
                        var val = this.field.val();

                        return !!(val && direct.utils.validateEmail(val));
                    },
                    error: iget('корректный email')
                },
                {
                    field: $('.b-search-client-id__client-id', $this),
                    isValid: function() {
                        var val = this.field.val();
                        return val.length ? /^\d+$/.test(val) : true;
                    },
                    error: iget('корректный ClientID')
                },
                {
                    field: $('.b-region-suggest__input', $this),
                    isValid: function() {
                        return !!this.field.val();
                    },
                    error: iget('город')
                }];

        $this.submit(function(){
            var errors = [];

            fields.forEach(function(data){
                data.field.length && !data.isValid() && errors.push(data.error);
            });

            if (errors.length) {
                return !!alert(iget('Необходимо указать') + ':\n —' + errors.join('\n — '));
            }
        });
    };
})(jQuery, window.Lego);
