BEM.DOM.decl('b-shared-popup', {

    _mods: null,

    _popup: null,

    onSetMod: {
        js: function() {
            this._mods = [];
            this._popup = this.findBlockOn('b-popupa');

            this._implantEvents(this._popup);
        },

        '*': function(modName) {
            this._mods && this._mods.push(modName);
        }
    },

    /**
     * Скрывает блок
     * @return {BEM}
     */
    hide: function() {
        this._popup.hide();

        return this;
    },

    /**
     * Показывает блок
     * @param {Object|jQuery} params - принимает объект с параметрами
     * @return {BEM}
     */
    show: function(params) {
        var popup = this._popup;

        // лезем в кишки, так как в api попапа нет метода сброса родительского попапа
        popup._parent = null;
        popup._isParentFixed = false;

        popup.show(params);

        return this;
    },

    /**
     * Показывает/скрывает блок в зависимости от текущего состояния.
     * Поведение метода изменено относительно такого же метода папапа
     * для правильного поведения при смене владельца
     * @param {jQuery|Object} [owner] DOM-элемент или координаты { left : x, top : y },
     * относительно которых рассчитывается положение
     */
    toggle: function(owner) {
        var popup = this._popup,
            currentOwner = popup._owner;

        if (owner instanceof BEM) {
            this.bemOwner = owner;

            //у старого попапа пока нет метода setParent
            popup.on('outside-click', function(e, data) {
                this.bemOwner.containsDomElem($(data.domEvent.target)) && e.preventDefault();
            }, this);

            owner = owner.domElem;
        }


        // если нет владельца или он не меняется, то работает метод попапа
        if (!currentOwner || currentOwner === owner) {
            popup.toggle(owner);
        } else {
            // если владелец меняется, то показываем попап с новым владельцем
            this.show(owner);
        }


        return this;
    },

    setContent: function(content) {
        this._cleanupMods();

        this._popup.setContent(content);

        return this;
    },

    destruct: function() {
        this._popup.destruct.apply(this._popup, arguments);
        this.__base.apply(this, arguments);
    },

    _cleanupMods: function() {
        this._mods
            .splice(0, this._mods.length)
            .forEach(function(modName) {
                this.delMod(modName);
            }, this);
    },

    /**
     * Видим ли на данный момент блок
     * @return {Boolean}
     */
    isShowed: function() {
        return this._popup.isShowed();
    },

    /**
     * Имплантация событий попапа в экземпляр блока
     * @param {BEM} popup
     * @private
     */
    _implantEvents: function(popup) {
        ['show', 'hide'].forEach(function(eventName) {
            popup.on(eventName, function() {
                this.trigger(eventName, { owner: popup._owner });
            }, this);
        }, this);
    }

}, {

    _instances: {},

    /**
     * Создает синглтон попапа по ключу хэша переданных мод попапа
     * @param {Object} [mods]
     * @return {BEM}
     */
    getInstance: function(mods, jsParams) {
        var popup,
            key = JSON.stringify(mods || {}) + '/' + JSON.stringify(jsParams || {});

        if (!this._instances[key]) {
            popup = {
                block: 'b-popupa',
                mix: [{ block: 'b-shared-popup', js: true }],
                js: jsParams || true,
                mods: mods,
                content: [{ elem: 'tail' }, mods['has-close'] == 'yes' && { elem: 'close' }, { elem: 'content' }]
            };

            this._instances[key] = $(BEM.HTML.build(popup)).appendTo(document.body).bem('b-shared-popup');
        }

        return this._instances[key];
    }

});
