(function($) {
    //utility - вспомогательное поле
   //server - отправляется на сервер
   //serverName - имя для хранения на сервере
   //input - напрямую вводится пользователем

   BEM.blocks['b-model'].register('b-sms-notification', {
       fields: {
           'active_orders_money_out_sms': {type: 'flag', input: 1, fromServer: 1, toServer: 1},
           'active_orders_money_warning_sms': {type: 'flag', input: 1, fromServer: 1, toServer: 1},
           'moderate_result_sms': {type: 'flag', input: 1, fromServer: 1, toServer: 1},
           'notify_metrica_control_sms': {type: 'flag', input: 1, fromServer: 1, toServer: 1},
           'notify_order_money_in_sms': {type: 'flag', input: 1, fromServer: 1, toServer: 1},
           'camp_finished_sms': {type: 'flag', input: 1, fromServer: 1, toServer: 1},
           'notify_metrica_control_sms_disabled': {type: 'flag'},
           'sms_time_hour_from': {type: 'string', 'default': '00', input: 1, fromServer: 1, toServer: 1},
           'sms_time_min_from': {type: 'string', 'default': '00', input: 1, fromServer: 1, toServer: 1},
           'sms_time_hour_to': {type: 'string', 'default': '00', input: 1, fromServer: 1, toServer: 1},
           'sms_time_min_to': {type: 'string', 'default': '00', input: 1, fromServer: 1, toServer: 1}
       }
   });

    var minutes = ['00', '15', '30', '45'];

    BEM.DOM.decl({ name:'b-sms-notification', baseBlock: 'b-model-block' }, {
        onSetMod : {
            js: function() {
                this.campModel =  BEM.blocks['i-models-manager'].get('campaign', 'b-campaign-edit');

                var self = this,
                    smsPhone = this.campModel.get('sms_phone') || this.params.phone;

                this.initConsts();
                this.initModel();
                this.bindEvents();
                var data = {
                     block: 'b-worktime',
                     mix: [{block: 'b-sms-notification', elem: 'time-row'}],
                    'all-day': 'yes',
                    'disabled':  smsPhone ? 0 : 1
                };
                data = $.extend(data, this._getTimeFromModel());
                this.elem('time').append(BEM.HTML.build(data));
                this.campModel.onField('finish_date', 'change', this.onFinishDateChanged, this);
                this.model
                    .onField('notify_metrica_control_sms_disabled', 'change', this.onMetrikaDisabledChanged, this)
                    .onField('sms_time_hour_from sms_time_min_from sms_time_hour_to sms_time_min_to', 'change', this.resetTime, this)


                if (smsPhone) {
                    this.timeControl = this.findBlockInside('b-worktime');
                    this.timeControl && this.timeControl.getChannel().on('change-time', function(e, time) {
                        self.model.update({
                            'sms_time_hour_from': time[0],
                            'sms_time_min_from': time[1],
                            'sms_time_hour_to': time[2],
                            'sms_time_min_to': time[3]
                        }, self)
                    })
                }


                this.onFinishDateChanged();
            }
        },

        resetTime: function(e, data) {
            if (data.source == this) { return; }
            this.timeControl && this.timeControl.setTime(this._getTimeFromModel());
        },


        onMetrikaDisabledChanged: function() {
            var disabled = this.model.get('notify_metrica_control_sms_disabled');
            this.elem('label-notify-metrica-control-sms').toggleClass('g-common__grey', disabled);
            this.getControl('notify_metrica_control_sms').bem.setMod('disabled', disabled ? 'yes' : 'no');
        },

        onFinishDateChanged: function() {
            var finishDate = this.campModel.get('finish_date'),
                control = this.getControl('camp_finished_sms'),
                disabled = !this.params.phone || !finishDate;

            if (!control) return;


            control.bem.setMod('disabled', disabled ? 'yes' : 'no');
            this.elem('label-camp-finished-sms').toggleClass('g-common__grey', disabled);
            if (disabled) {
                control.bem.delMod('checked');
            }
        },

        initConsts: function() {
            this._modelPath = 'campaign';
            this._modelName = 'b-sms-notification';
        },

        _getTimeFromModel: function() {
            return {
                'hour-from': +this.model.get('sms_time_hour_from'),
                'min-from': this.model.get('sms_time_min_from'),
                'hour-to': +this.model.get('sms_time_hour_to'),
                'min-to': this.model.get('sms_time_min_to')
            }
        },

        bindEvents: function() {
            this.__base();

        }

    });



})(jQuery);

