/**
 * Created by IntelliJ IDEA.
 * User: heliarian
 * Date: 23.08.2010
 * Time: 18:02:44
 * To change this template use File | Settings | File Templates.
 */



(function($, Lego) {
Lego.block['b-sortable-table'] = function(params) {
    var $this = $(this),
        sortHeaderRegexp = /(^|.*\s)sort-header-(\S+)/,
        sortHeadersArr = $this.find('.b-sortable-table__header'),
        sortHeaders = {},
        defaultOrders = {},
        valueTagNames = {},
        finders = params.finders || {},
        pseudoClassSelector = params.pseudoClassSelector || '',
        precedingElementSelector = params.precedingElementSelector || '',
        updateSelectorForFields = params.updateSelectorForFields || [],

        sortComparators = {
            forward: function (a, b) { return comparator(a, b) },
            backward: function(b, a) { return comparator(a, b) }
        },
        findersFunctions = {
            string: findRowsForString,
            number: findRowsForNumber
        },
        api = { sortBy: sortBy, sortedNow: '', clearHeaders: clearHeaders };

        $this.data('api', api);

        initHeaders();
        bindEvents();

        function comparator(a, b){
            var aOrd = typeof a.order == 'string' ? a.order.toLowerCase() : a.order,
                bOrd = typeof b.order == 'string' ? b.order.toLowerCase() : b.order;
            return aOrd > bOrd ? 1 : (aOrd == bOrd ? 0 : -1)
        }

        function getFieldName(headerNode) {
            return headerNode.className.match(sortHeaderRegexp)[2]
        }

        function findRowsForString(rowsContainer, tag, fieldName) {
		    return findRowsForFunction.call(this, rowsContainer, tag, fieldName, function(node){
			    return node.innerHTML;
		    });
	    }

        function findRowsForNumber(rowsContainer, tag, fieldName) {
            return findRowsForFunction.call(this, rowsContainer, tag, fieldName, function(node){
                var total = node.innerHTML.replace(/&nbsp;/g, ' ').replace(/\s/g, '').match(/\d+([.,]\d+)?/);
                return total ? parseFloat(total[0].replace(',', '.')) : 0;
            });
        }

        function findRowsForFunction(rowsContainer, tagName, fieldName, orderFunction) {
            var sortableValuesWrappersSelector = tagName + '.' + 'sort-' + fieldName;

            if($.inArray(fieldName, updateSelectorForFields) > -1) {
                sortableValuesWrappersSelector = precedingElementSelector + ' ' + sortableValuesWrappersSelector + pseudoClassSelector;
            }
            return rowsContainer.find(sortableValuesWrappersSelector).map(function(i, node) {
                return {
                    'node': $(node).closest('tr'),
                    'order': orderFunction(node)
                }
            });
        }

        function initHeaders() {
            $.each(sortHeadersArr, function(i, header) {
                var name = getFieldName(header),
                    $header = $(header);

                sortHeaders[name] = $header;
                defaultOrders[name] = $header.hasClass('sort-default-backward') ? 'backward' : 'forward';

                finders[name] = finders[name] || findersFunctions[$header.hasClass('sort-type-number') ? 'number' : 'string'];

                var match = header.className.match(/sort-tag-(\w+)/);
                valueTagNames[name] = match ? match[1].split('-') : 'span';
            })

        }

        function bindEvents() {
            for (var i in sortHeaders) {
                if (!sortHeaders.hasOwnProperty(i)) continue;
                sortHeaders[i].bind('click', {name: i}, onSortHeaderClick);
            }
        }

        function onSortHeaderClick(e) {
            sortBy(e.data.name);
        }

        function sortBy(name, resort) {
            var node = sortHeaders[api.sortedNow = name],
                sortOrder = node.hasClass('sort-forward') ? 'forward' : (node.hasClass('sort-backward') ? 'backward' : '');

            if (!sortOrder) {
                sortOrder = defaultOrders[name];
            } else {
                !resort && (sortOrder = sortOrder == 'forward' ? 'backward' : 'forward');
            }

            clearHeaders();

            node.addClass('sort-' + sortOrder);

            var toBeSorted = [],
                sortableContainers = $this.find(".b-sortable-container");

            if (!sortableContainers.length) sortableContainers = [$this];
            $.each(sortableContainers, function(index, item){
                var rowsContainer = $(item);
                toBeSorted.push({
                    container: rowsContainer,
                    rows: finders[name].call(this, rowsContainer, valueTagNames[name], name)
                })
            });

            //sorting each rows container separately
            $.each(toBeSorted, function(index, item){
                var rows = item.rows;

                rows.sort(sortComparators[sortOrder]);
                for (var i = 0, l = rows.length; i < l; i++) {
                    if (params.oddClass) rows[i].node.toggleClass(params.oddClass,  i & 1);
                    if (params.evenClass) rows[i].node.toggleClass(params.evenClass,  !(i & 1));
                    item.container.append(rows[i].node)
                }
            });
        }

        function clearHeaders() {
            for (var i in sortHeaders) {
			    if (!sortHeaders.hasOwnProperty(i)) continue;
                sortHeaders[i].removeClass('sort-forward sort-backward')
		    }
        }

};
})(jQuery, window.Lego);
