BEM.DOM.decl('b-stat-banner-preview', {

    onSetMod: {
        js: function() {
            this.popup = this.findBlockOn(this.elem('popup'), 'b-popupa');
            this.content = this.elem('content');
            this.bindTo(this.elem('banner'), 'click', function(e) {

                var el = $(e.currentTarget),
                    bid = this.elemParams(el).bid,
                    ulogin = this.params.ulogin,
                    request = BEM.create('i-request_type_ajax', {
                        url: '/registered/main.pl',
                        dataType: 'json'
                    });

                e.preventDefault();

                request.get({
                    cmd: 'getBanners',
                    bid: bid,
                    ulogin: ulogin
                }, function(data) {
                    var ctx = data[0];
                    ctx.text = ctx.body;
                    ctx.cid = this.params.cid;
                    ctx.id = ctx.bid;
                    ctx.vcard && (ctx.vcard = '/registered/main.pl?cmd=showContactInfo&bid=' + ctx.bid + '&cid=' + ctx.cid)

                    BEM.blocks['i-models-manager'].create('b-banner-edit', 'campaign&banner:' + ctx.bid, ctx);

                    ctx.sitelinks && ctx.sitelinks.forEach(function(link) {
                        link.href = 'http://' + link.href;
                    })

                    BEM.DOM.update(this.content, BEM.HTML.build({
                        block: 'b-stat-banner-preview',
                        elem: 'preview-holder',
                        ulogin: ulogin,
                        bannerData: ctx
                    }))

                    this.popup.show(el);

                },{
                    cache: false,
                    callbackCtx: this
                })
            })
        }
    }
})

{
    BEM.HTML.decl('b-stat-banner-preview', {

        onElem: {
            'preview-holder': function(ctx) {

                var bannerData = ctx.param('bannerData');

                ctx.content([
                    $.extend(bannerData, { block: 'b-banner-preview', js: { modelPath: 'campaign&banner:' + bannerData.bid, cid: bannerData.cid } }),
                    {
                        elem: 'footer',
                        content: {
                            elem: 'edit-link',
                            bid: bannerData.bid,
                            cid: bannerData.cid,
                            ulogin: ctx.param('ulogin')
                        }
                    }
                ])
            },

            'edit-link': function(ctx) {
                ctx
                    .tag('a')
                    .attrs({
                        href: '/registered/main.pl?cmd=showCampMultiEdit&bids='
                            + ctx.param('bid') + '&cid=' + ctx.param('cid') + '&ulogin=' + ctx.param('ulogin')
                    })
                    .content(iget('Редактировать объявление'))
            }
        }
    })

}
