(function($, Lego) {
    Lego.block['b-statistics-data'] = function(params) {
        var $this = $(this),
            expander = $this.find('.b-statisctics-data__expander'),
            expandContainer = $this.find('.b-statisctics-data__expand-container');
        var expandersHash = {}, expandContainers = {};

        expandContainer.each(function(i, container) {
            var data = container.onclick() || {};
            expandContainers[data.id] = $(container);
        });

        expander.each(function(i, element) {
            var data =  element.onclick() || {};
            expandersHash[data.id] = {
                href: element.href,
                opened: false,
                img: $(element).find('.b-statisctics-data__expander-img'),
                cache: ''
            }
            $(element).bind('click', {id: data.id}, showData)
        })



        function showData(e) {
            e.preventDefault();
            var id = e.data.id;
            expandersHash[id].opened = !expandersHash[id].opened;
            var imgSrc = expandersHash[id].opened ? '/i/hide.gif' : '/i/show.gif';
            expandersHash[id].img.attr('src', imgSrc);
            if (!expandersHash[id].cache) {
                getCache(id);
            } else {
                expandContainers[id].toggleClass('g-hidden');
            }
            return false;
        }

        function getCache(id) {

            $.get(expandersHash[id].href, function(result) {
                onCacheLoaded(result, id)
            });
        }

        function onCacheLoaded(result, id) {
            expandersHash[id].cache =  $(result);
            var container = expandContainers[id];
            container.empty().append($(result));
            expandContainers[id].toggleClass('g-hidden');
        }

    }
})(jQuery, window.Lego);
