
(function($, Lego) {
    Lego.block['b-statistics__form'] = function(params) {
        var $this  = $(this),
            form = $this.find('.b-statistics__form__form-element'),
            calendarFrom = $this.find('.b-statistics__form__calendar-from'),
            calendarTo = $this.find('.b-statistics__form__calendar-to'),
            submitButton = $this.find('.b-statistics__form__submit'),
            statPeriodsHidden = $this.find('.b-statistics__form__stat-periods'),
            offlineStat = $this.find('.b-statistics__form__offline-stat'),
            showFavoritesHidden = $this.find('.b-statistics__form__show-favorites'),
            sortingHidden = $this.find('.b-statistics__form__sorting'),
            reverseHidden = $this.find('.b-statistics__form__reverse'),
            onlineStat = $this.find('.b-statistics__form__online-stat'),
            statPeriods = $this.find('.b_statistics__form__quick_date_select__period'),
            sortingLinks = $('.b-statistics__sorting'),
            page = $this.find('.b-statistics__form__page'), // DIRECT-18002

            detailStat = $('#show_banners_stat'), // чекбокс "показать детальную статистику по объявлениям"
            metrikaBtn = $('#metrika-btn'), //кнопка показать/скрыть метрику
            loadXls = $('#load-xls'), //ссылка "скачать в xls"
            showFavorites = $('#show-favorites'), //ссылка "показать самые важные"
            showAll = $('#show-all'), //ссылка "показать все"

            show_link_tr = $this.find('.b-statistics__form__advanced-link'), // контейнер ссылки "Показать дополнительные настройки"
            show_link = $this.find('.b-statistics__form__show-link'), // ссылка "Показать дополнительные настройки"
            advanced = $this.find('.b-statistics__form__advanced'), // параметры, которые мы считаем дополнительными

            discount_checkbox = $this.find('.b-statistics__form__discount-checkbox input'),
            discount_hidden = $this.find('.b-statistics__form__discount-hidden'),

            cTo, cFrom,
        
            calendarFromHiddens = 'y1 m1 d1'.split(' '),
            calendarToHiddens = 'y2 m2 d2'.split(' '),

            staticPeriods = [];

        sortingLinks.click(function(e) {
            e.preventDefault();

            sortingHidden.val(this.className.match(/b-statistics__sorting_name_(.*)/)[1]);
            reverseHidden.val(reverseHidden.val() == 1 ? 0 : 1);

            submitForm();
        });

        loadXls.click(function(e) {
            e.preventDefault();
        });



        $(document)
            .bind('b-statistics__form:updateToDate', updateToDate)
            .bind('b-statistics__form:updateFromDate', updateFromDate)
            .bind('b-statistics__form:load-offline', onLoadOffline)
            .bind('b-statistics__form:load-online', onLoadOnline);

        statPeriods.each(function(i, period) {
            var link = $(period).find('.b_statistics__form__quick_date_select__link');
            var from = getFromPeriodData($(period));
            var to = getToPeriodData($(period));
            if ($(period).hasClass('b_statistics__form__quick_date_select__period')) {
                staticPeriods.push(from.join('-') + ':' + to.join('-'));
            }
            link.bind('click',{from: from, to: to}, setPeriod)
        });
        if (calendarFrom[0] && $.isFunction(calendarFrom[0].onclick)) {
            
            var dateFrom = calendarFrom[0].onclick();
            cFrom = new clite(dateFrom.y + '-' + dateFrom.m + '-' + dateFrom.d);
            cFrom.addField('y1', '%Y');
            cFrom.addField('m1', '%M');
            cFrom.addField('d1', '%D');
            cFrom.appendToPlace(calendarFrom[0]);

        }

        if (calendarTo[0] && $.isFunction(calendarTo[0].onclick)) {
            var dateTo = calendarTo[0].onclick();
            cTo = new clite(dateTo.y + '-' + dateTo.m + '-' + dateTo.d);
            cTo.addField('y2', '%Y');
            cTo.addField('m2', '%M');
            cTo.addField('d2', '%D');
            cTo.appendToPlace(calendarTo[0]);
        }

        show_link.click(function() {
            advanced.each(function() {
                $(this).removeClass('g-hidden')
            });
            show_link_tr.addClass('g-hidden');

            yasetCookie('b-statistics-form_show-default_yes~cid:' + form.get(0).cid.value, 1, 1);
        });

        metrikaBtn.click(function(e) {
            var $this = $(this);

            if ($this.hasClass('b-statistics-yashow')) {
                yashow();
            } else {
                yahide();
            }
        });

        showAll.click(function(e) {
            e.preventDefault();

            showFavoritesHidden.val('');
            submitForm();

            return false
        });

        showFavorites.click(function(e) {
            e.preventDefault();

            showFavoritesHidden.val(1);
            submitForm();

            return false
        });

        discount_checkbox.click(function() {
            discount_hidden.val(!this.checked ? 1 : 0);
        });

        submitButton.click(savePeriod);

        function yashow() {
            var name = 'directya',
                value = 0,
                expires = new Date(0),
                domain = direct.utils.extractDomain(document.location.host).replace(/:\d+/, '');
            yasetCookie(name, value, expires, null, domain);

            submitForm();
        }

        function yahide() {
            var name = 'directya',
                value = 1,
                expires = new Date();

            expires.setYear(1900 + expires.getYear() + 1);
            // Change the date to next year
            var domain = direct.utils.extractDomain(document.location.host).replace(/:\d+/, '');
            yasetCookie(name, value, expires, null, domain);

            submitForm();
        }


        function getFromPeriodData(period) {
            var from = [];
            $.each(calendarFromHiddens, function(i, name) {
                from[i] = period.find('.calendar-' + name).val()
            })
            return from;
        }

        function getToPeriodData(period) {
            var to = [];
            $.each(calendarToHiddens, function(i, name) {
                to[i] = period.find('.calendar-' + name).val()
            });
            return to;
        }



        function setPeriod(e) {
            var from = e.data.from,
                to = e.data.to;
            cFrom.update_date(from.join('-'));
            cTo.update_date(to.join('-'));
            
        }

        function updateToDate(e, date) {
            cTo.update_date(date);    
        }

        function updateFromDate(e, date) {
            cFrom.update_date(date);
        }

        function validatePeriod(from, to) {
            if (from[0] < to[0]) { return true; }
            if (from[0] > to[0]) { return false; }
            if (from[1] < to[1]) { return true; }
            if (from[1] > to[1]) { return false; }
            if (from[2] > to[2]) { return false; }
            return true;
        }

        function validateRange(from, to) {
            if (from[0] < 2000 || to[0] < 2000) { return false; }
            return true;
        }

        function validate(from, to) {
            if (!validatePeriod(from, to)) { alert(iget('Дата начала периода должна быть раньше даты конца')); return false;}
            if (!validateRange(from, to)) {alert(iget('Выбранный период должен начинаться не раньше 1 января 2000 года')); return false;}
            return true;
        }

        function savePeriod(e) {
            var from =  getFromPeriodData(calendarFrom),
                to = getToPeriodData(calendarTo),
                period = from.join('-') + ':' + to.join('-');
            
            if (!validate(from, to)) { return false; }

            var periods =  (direct.UserOptions.get('stat_periods') || '').split(',');

            if ($.inArray(period, periods) == -1 && $.inArray(period, staticPeriods) == -1) {
                periods.unshift(period);
                if (periods.length > 3) { periods = periods.slice(0, 3)}
                statPeriodsHidden.val(periods.join(','));
            }

            // DIRECT-18002 (Комментарий Александров Алексей: При нажатии на кнопку показать, в мастере отчётов, не нужно отправлять текущий номер страницы (page))
            page.val('');

            // DIRECT-13068 (если есть чекбокс "показать детальную статистику" есть и не взведён, сабмитим форму, не показывая окно о длительной обработке данных)
            detailStat[0] && !detailStat.prop('checked') ?
                onLoadOnline() :
                checkOnline();
            return false;
            
        }
        
        function onOnlineCheckComplite(isOffline) {
            +isOffline ?
                $(document).trigger('b-statistics__form:ofline-warning') :
                submitForm();
        }

        function submitForm() {
            var submitUrl = form.attr('action') + '?' + form.serialize();
            form
                .attr('method', submitUrl && submitUrl.length > 2048 ? 'POST' : 'GET')
                .submit();
        }
        
        function onLoadOnline() {
            offlineStat.val(0);
            onlineStat.val(1)
            submitForm();
        }
        
        function onLoadOffline() {
            offlineStat.val(1);
            onlineStat.val(0)
            submitForm();
        }
        
        function checkOnline() {
            offlineStat.val(0);
            onlineStat.val(0);
            $.ajax({
                url: '/registered/main.pl',
                type: 'POST',
                data: form.serialize() + '&check_offline=1',
                success: onOnlineCheckComplite,
                error: function() {
                    onOnlineCheckComplite(1);
                }
            });
        }



    };
})(jQuery, window.Lego);
