(function($, Lego) {
    Lego.block['b-statistics__form__custom-filter'] = function(params) {
        var $this = $(this),
            model = params.model,
            blocks = ['tag', 'banner', 'page', 'phrase', 'geo', 'adgroup', 'position', 'image', 'date', 'retargeting', 'nds', 'discount'],
            $controls = {};

        model.bind('reset', onModelReset);

        parseInputs();
        saveStateInModel();
        bindEvents();

        function bindEvents() {
            $.each(blocks, function(i, blockName) {
                $controls[blockName].ch.bind('click', {blockName: blockName}, onCheckboxClick);
                $controls[blockName].inputs.each(function(i, elem) {
                    var events = elem.type == 'checkbox' ? 'click' : 'change';
                    $(elem).bind(events, {blockName: blockName}, onInputChange)
                })
            });
        }

        function saveStateInModel() {
            var data = {};
            $.each(blocks, function(i, blockName) {
                data[blockName] =  $controls[blockName].ch.prop('checked') ? 1 : 0;
                $controls[blockName].inputs.each(function(i, elem) {
                    data[$(elem).attr('name')] =  elem.type == 'checkbox' ?
                                                    $(elem).prop('checked') ? 0 : 1 :
                                                    $(elem).val();
                });
            });
            model.reset(data, $this);
        }

        function onInputChange(e) {
            var $this = $(this);

            model.set($this.attr('name'), this.type == 'checkbox' ? $this.prop('checked') : $this.val());
        }

        function parseInputs() {
            $.each(blocks, function(i, blockName) {
                var block = $this.find('.b-sform__custom-filter__' + blockName);
                $controls[blockName] = {
                    ch: block.find('.b-sform__custom-filter__ch input'),
                    inputs: block.find('.b-sform__custom-filter__input')
                }
            });
        }

        function onCheckboxClick(e) {
            var blockName = e.data.blockName, checked = $(this).prop('checked');
            model.set(blockName, $(this).prop('checked'));
            $controls[blockName].inputs.each(function(i, input) {
                $(input).prop('disabled', !checked);
            });
        }

        function setInputsState(blockName, disabled, data) {
            $controls[blockName].inputs.each(function(i, input) {
                $(input).prop('disabled', disabled);
                if (input.type == 'checkbox') {
                    $(input).prop('checked', data[$(input).attr('name')] * 1);
                } else {
                    $(input).val(data[$(input).attr('name')]);
                }
            })
        }

        function onModelReset(e) {
            if (e.source == $this) return;
            var data = e.changed, inputs, ch;

            $.each(blocks, function(i, blockName) {
                $controls[blockName].ch.prop('checked', data[blockName]);
                setInputsState(blockName, !data[blockName], data);
            })
        }

    }
})(jQuery, window.Lego);
