(function($, Lego) {
    Lego.block['b-statistics__form__saved-custom-filters'] = function(params) {
        var $this = $(this),
            model = params.model,
            menuList = $this.find('.b-sform__menu-list'),
            nameInput = $this.find('.b-sform__name-set .b-input__text'),
            addBtn = $this.find('.b-sform__add-btn'),
            checks = $('.b-sform__custom-filter__ch input'),
            filtersCount = 0,
            savedData = {},
            menuLinks = {};

        addBtn.click(addFilter);

        setData();
        buildMenu();

        function addFilter(e) {
            if (filtersCount >= 5) {
                alert(iget("У Вас уже есть 5 сохраненных настроек. Удалите одну из них, если хотите сохранить новую."));
                return false;
            }
            var name = nameInput.val();
            if (direct.utils.isEmpty(name)) {
                alert(iget("Введите название настройки!"));
                return false;
            }
            for (var prop in savedData) {
                if (name == prop) {
                    alert(iget("У Вас уже есть настройка с таким названием."));
                    return false;
                }
            }
            buildMenuElement(name);
            addElementData(name);
            sendSaveDataRequest();
            nameInput.val('');
        }

        function addElementData(name) {
            savedData[name] = model.memento();
        }

        function sendSaveDataRequest() {
            var dataStr = $.stringify(savedData);
            direct.UserOptions.set('custom_filters', dataStr)
        }

        function buildMenu() {
            menuList.hide();
            $.each(savedData, function(name, data) {
                buildMenuElement(name);
            });

            menuList.show();
        }

        function buildMenuElement(name) {
            var parent = $('<div/>', {
                'class': 'b-sform__menu-list__link-container'
            });
            $('<a class="b-sform__menu-list__link" href="#">' + name + '</a>')
                .bind('click', function(e) {
                    e.preventDefault();
                    selectFilter(name);
                }).appendTo(parent);

            $('<a class="b-sform__menu-list__link b-sform__menu-list__link_icon" href="#" title ="' + iget('Удалить') + '"><img src="/i/x_off.png" width="12" height="12" border="0"></a>')
                .bind('click', function(e) {
                    e.preventDefault();
                    deleteFilter(name);
                }).appendTo(parent);
            parent.appendTo(menuList);
            filtersCount++;
            menuLinks[name] = parent;
        }

        function selectFilter(name) {
            model.reset(savedData[name]);
            checks.each(function(){
                $(this).parent().bem('b-form-checkbox').setMod('checked', this.checked ? 'yes' : 'no');
            });
        }

        function deleteFilter(name) {
            filtersCount--;
            menuLinks[name].remove();
            delete savedData[name];
            sendSaveDataRequest();
        }

        function setData() {
            var dataStr = direct.UserOptions.get('custom_filters');
            savedData = dataStr ? JSON.parse(dataStr) : dataFromCookies_old();

        }

        /*
         * Устанавливает данные из кук - пока есть пользователи с сохраненными в куках настройками, от этого метода отказаться не можем
         */
        function dataFromCookies_old() {
            var dataStr = getCookie_old(), savedData = {};
            if (dataStr) {
                $.each(dataStr.split("-||-"), $.proxy(function(i, row) {
                    var data = row.split('::'),
                        name = data[0];
                    savedData[name] = proxyData_old(data);
                }, this))
            }
            return savedData;
        }

        function proxyData_old(data) {
            var checkboxes = data[1].split("&") || [];
            return  {
                'banner': $.inArray('13', checkboxes) != -1,
                'page': $.inArray('15', checkboxes) != -1,
                'phrase': $.inArray('18', checkboxes) != -1,
                'geo': $.inArray('20', checkboxes) != -1,
                'position': $.inArray('22', checkboxes) != -1,
                'date': $.inArray('23', checkboxes) != -1,
                'filter_banner': data[2],
                'filter_page': data[3],
                'filter_page_target': data[4],
                'filter_phrase': data[5],
                'filter_geo': data[6],
                'group': data[7],
                'filter_position': data[9],
                'use_page_id': data[10],
                'nds': data[11],
                'discount': data[12]
            }
        }

        function getCookie_old()
        {
            var sName = "java_custom",
                aCookie = document.cookie.split("; ");
                for (var i=0; i < aCookie.length; i++) {
                    var aCrumb = aCookie[i].split("=");
                    if (sName == aCrumb[0]) {
                        return unescape(aCrumb[1]);
                    }
                }
            return null;
        }

    }
})(jQuery, window.Lego);
