(function($){
// стратегия "Средняя цена клика"
    BEM.blocks['b-model'].register('b-strategy-autobudget-avg-click', {

        fields: {
            'sum': { type: 'number', precision: 2, 'default': '', defaultView: '' },
            'avg_bid': { type: 'number', precision: 2, 'default': '', defaultView: '' },
            'currency': { type: 'const', 'default': 'YND_FIXED' }
        },

        validateRules: function(){
            var curr = get_currency(this.get('currency'));
            return {
                'sum': {
                    'list': [
                        {
                            id: 'min', name: 'min', value: curr.MIN_AUTOBUDGET,
                            text: iget("Недельный бюджет не может быть меньше %s", curr.MIN_AUTOBUDGET + ' ' + curr.name)
                        },
                        {
                            id: 'max', name: 'max', value: curr.MAX_AUTOBUDGET,
                            text: iget("Указан слишком большой недельный бюджет")
                        }
                    ]
                },
                'avg_bid': {
                    'list': [
                        {
                            id: 'required', name: 'required',
                            text: iget("Не указано значение средней цены клика")
                        },
                        {
                            id: 'format', name: 'format',
                            text: iget("Неверно указано значение средней цены клика")
                        },
                        {
                            id: 'min', name: 'min', value: curr.MIN_AUTOBUDGET_AVG_PRICE,
                            text: iget("Средняя цена за клик должна быть не менее %s", curr.MIN_AUTOBUDGET_AVG_PRICE + ' ' + curr.name)
                        },
                        {
                            id: 'max', name: 'max', value: curr.MAX_AUTOBUDGET_BID,
                            text: iget("Средняя цена за клик не может превышать %s", curr.MAX_AUTOBUDGET_BID + ' ' + curr.name)
                        },
                        {
                            id: 'maxfield',
                            name: 'max',
                            value: function() { return this.get('sum') },
                            condition: function(){ return this.get('sum') > 0 },
                            text: iget("Недельный бюджет должен быть больше средней цены клика.")
                        }
                    ]

                }
            }
        }
    });

    BEM.DOM.decl({name: 'b-strategy-autobudget-avg-click', baseBlock: 'b-model-block'}, {
        onSetMod: {
            'js': function(){
                var _this = this;

                this.initConsts();
                this.initModel();
                this.bindErrorEvents();

                this.model
                    .on('reset', function(){ _this.updateDomByModel() })
                    .onField('avg_bid', 'change', function(){ this.onBidChange() }, this)
                    .onField('sum', 'change', function(){ this.onSumChange() }, this);

                this.elem('sum')
                    .keyup(function(){ _this.updateDisabled() })
                    .add(this.elem('avg-bid'))
                        .change(function(){ _this.updateModel() });

                this.updateDomByModel();

            }
        },

        getStrategyData: function(){
            var model = this.model,
                currency =  '&nbsp;' + format_currency(model.get('currency')),
                strategy = { name: 'autobudget-avg-click', sum: model.get('sum'), avg_bid: model.get('avg_bid') };

            model.stateData = model.memento();

            return {
                strategy: strategy,
                description: {
                    title: this.params.title,
                    text: iget('Удерживать цену клика %s в среднем за неделю', strategy.avg_bid + currency) +
                        (strategy.sum ? ',' + iget('<br/>при недельном бюджете не более %s', strategy.sum + currency) : '')
                }
            }
        },


        updateModel: function () {
            var notDigit = /[^\d.,/\-]*/g,
                avgBid = this.elem('avg-bid').val().replace(notDigit, ''),
                sum = this.elem('sum').val().replace(notDigit, '');

            avgBid == '' && this.elem('avg-bid').val('');
            sum == '' && this.elem('sum').val('');

            this.model.update({
                avg_bid: avgBid,
                sum: sum
            });
        },


        updateDomByModel: function(){
            this.model.stateData = this.model.memento();
            this.onSumChange();
            this.onBidChange();

        },

        onBidChange: function () {
            this.elem('avg-bid').val(this.model.view('avg_bid'));
        },

        onSumChange: function () {
            var sumIsNum = +this.model.get('sum');
            this.elem('sum').val(sumIsNum ? this.model.view('sum') : '');
            !sumIsNum && this.model.set('sum', '');
            this.updateDisabled();
        },

        updateDisabled: function(){
            this.toggleMod(this.elem('sum-container'), 'mod', 'disabled', !this.elem('sum').val());
        }

    }, {
        live: true
    });

})(jQuery);
