BEM.blocks['b-model'].register('b-strategy-autobudget-avg-cpa', {

    fields: {
        'no_save': { type: 'flag', 'default': false },
        'avg_cpa': { type: 'number', precision: 2, 'default': '', defaultView: '' },
        'sum': { type: 'number', precision: 2, 'default': '', defaultView: '' },
        'bid': { type: 'number', precision: 2, 'default': '', defaultView: '' },
        'goal_id': { type: 'string' },
        'currency': { type: 'const', 'default': 'YND_FIXED' },

        'all_goals_deleted': { type: 'flag' },
        'count_all_goals': { type: 'number' },
        'count_all_context_goals': { type: 'number' },
        'compaign_domains_count': { type: 'number', precision: 0 },
        'campaign_goals': { type: 'const', 'default': {} },
        'cpa_deviation': {type: 'flag'},
        'apc_deviation': {type: 'flag'}

    },

    validateRules: function() {
        var curr = get_currency(this.get('currency'));

        return {
            'no_save': {
                'list': [
                    {
                        id: 'check',
                        validator: function(value) { return !value },
                        text: iget('Невозможно подключить среднюю цену конверсии.')
                    }
                ]
            },
            'sum': {
                'list': [
                    {
                        id: 'min',
                        name: 'min',
                        value: curr.MIN_AUTOBUDGET,
                        text: iget("Недельный бюджет не может быть меньше %s", curr.MIN_AUTOBUDGET + ' ' + curr.name)
                    },
                    {
                        id: 'max',
                        name: 'max',
                        value: curr.MAX_AUTOBUDGET,
                        text: iget("Указан слишком большой недельный бюджет")
                    }
                ]
            },
            'avg_cpa': {
                'list': [
                    {
                        id: 'required',
                        name: 'required',
                        condition: function() { return !this.get('no_save') },
                        text: iget('Не указано значение средней цены конверсии')
                    },
                    {
                        id: 'min',
                        name: 'min',
                        value: curr.MIN_AUTOBUDGET_AVG_CPA,
                        text: iget('Средняя цена конверсии должна быть больше или равна %s', curr.MIN_AUTOBUDGET_AVG_CPA + ' ' + curr.name)
                    },
                    {
                        id: 'format',
                        name: 'format',
                        text: iget('Неверно указано значение средней цены конверсии')
                    },
                    {
                        id: 'maxfield',
                        name: 'max',
                        value: function() { return this.get('sum') - 0.01 },
                        condition: function() { return this.get('sum') > 0 },
                        text: iget('Недельный бюджет должен быть больше средней цены конверсии.')
                    }
                ]
            },
            'bid': {
                list: [
                    {
                        id: 'min',
                        name: 'min',
                        value: curr.MIN_AUTOBUDGET_AVG_PRICE,
                        text: iget('Максимальная цена клика должна быть больше или равна %s', curr.MIN_AUTOBUDGET_AVG_PRICE + ' ' + curr.name)
                    },
                    {
                        id: 'max',
                        name: 'max',
                        value: curr.MAX_PRICE,
                        text: iget('Максимальная цена клика должна быть меньше или равна %s', curr.MAX_PRICE + ' ' + curr.name)
                    },
                    {
                        id: 'maxfield',
                        name: 'max',
                        value: function() { return this.get('sum') - 0.01 },
                        condition: function() { return this.get('sum') > 0 },
                        text: iget('Недельный бюджет должен быть больше максимальной цены клика.')
                    }
                ]
            }
        }
    }
});

BEM.DOM.decl({ name: 'b-strategy-autobudget-avg-cpa', baseBlock: 'b-strategy-autobudget' }, {
    onSetMod: {
        'js': function() {
            var _this = this;

            this.initConsts();
            this.initModel();
            this.bindErrorEvents();


            this.goalsWhere = this.params.where == 'search' ? '' : 'context_';
            this.bid = this.elem('bid');
            this.avgCpa = this.elem('avg-cpa');
            this.goalId = this.elem('goal-select');
            this.sum = this.elem('sum');
            this.inputs = this.sum
                .add(this.avgCpa)
                .add(this.bid);

            this.model
                .onField('avg_cpa', 'change', this.updateDomByModel, this)
                .onField('bid', 'change', this.updateDomByModel, this)
                .onField('goal_id', 'change', this.updateDomByModel, this)
                .onField('sum', 'change', this.updateDomByModel, this);

            this.bindTo(this.inputs, 'change', this.updateModel, this);
            this.bindTo(this.goalId, 'change', this.updateModel, this);

            this.sum
                .add(this.bid)
                    .keyup($.debounce(function() { _this.updateDisabled(); }, 100)
                );

            this.updateDomByModel();

            this.updateDisabled();

        }
    },

    getStrategyData: function() {
        var model = this.model,
            currency =  '&nbsp;' + format_currency(model.get('currency')),
            strategy = {
                name: 'autobudget-avg_cpa',
                avg_cpa: model.get('avg_cpa'),
                sum: model.get('sum'),
                bid: model.get('bid'),
                goal_id: model.get('goal_id')
            },
            state = [];

        model.stateData = model.memento();

        strategy.sum && state.push('sum');
        strategy.bid && state.push('bid');
        strategy.goal_id != 0 && state.push('goal');

        return {
            strategy: strategy,
            description: {
                title: this.params.title,
                text: this.label()[state.join('-') || 'default']
            }
        }
    },

    label: function() {
        var currency = format_currency(this.model.get('currency')),
            helpIcon = '&nbsp;' + BEM.HTML.build({
                block: 'b-help-link',
                uri: get_help_url('average-cpa-features'),
                mix: [{ block: 'b-strategy-autobudget-avg-cpa', elem: 'label-icon' }]
            }),
            help = this.hint == 'goal-deleted' ?
                helpIcon :
                '',
            warning = this.hint == 'cpa-deviation' ?
                '<div class="b-strategy-autobudget-avg-cpa__warning">' +
                    BEM.HTML.build({
                        block: 'b-icon',
                        mods: { 'size-16': 'notice' }
                    }) +
                    iget('Внимание! Стоимость конверсии значительно отличается от установленного значения.') +
                    helpIcon +
                '</div>'
                    :
                '';
        return {
            'default': iget('Удерживать цену конверсии %s в среднем за неделю по всем целям' + warning,
                this.model.get('avg_cpa') + ' ' + currency),
            'goal': iget('Удерживать цену конверсии %s в среднем за неделю по цели «%s»' + help + warning,
                this.model.get('avg_cpa') + ' ' + currency, this.goalId.find('option:selected').text()),
            'sum-bid': iget('Удерживать цену конверсии %s в среднем за неделю по всем целям, тратить в неделю не более %s, при максимальной цене клика не более %s' + warning,
                this.model.get('avg_cpa') + ' ' + currency, this.model.get('sum') + ' ' + currency, this.model.get('bid') + ' ' + currency),
            'sum-bid-goal': iget('Удерживать цену конверсии %s в среднем за неделю по цели «%s»' + help + ', тратить в неделю не более %s, при максимальной цене клика не более %s' + warning,
                this.model.get('avg_cpa') + ' ' + currency, this.goalId.find('option:selected').text(),  this.model.get('sum') + ' ' + currency, this.model.get('bid') + ' ' + currency),
            'bid': iget('Удерживать цену конверсии %s в среднем за неделю по всем целям, при максимальной цене клика не более %s' + warning,
                this.model.get('avg_cpa') + ' ' + currency, this.model.get('bid') + ' ' + currency),
            'bid-goal': iget('Удерживать цену конверсии %s в среднем за неделю по цели «%s»' + help + ', при максимальной цене клика не более %s' + warning,
                this.model.get('avg_cpa') + ' ' + currency, this.goalId.find('option:selected').text(), this.model.get('bid') + ' ' + currency),
            'sum': iget('Удерживать цену конверсии %s в среднем за неделю по всем целям, тратить в неделю не более %s' + warning,
                this.model.get('avg_cpa') + ' ' + currency, this.model.get('sum') + ' ' + currency),
            'sum-goal': iget('Удерживать цену конверсии %s в среднем за неделю по цели «%s»' + help + ', тратить в неделю не более %s' + warning,
                this.model.get('avg_cpa') + ' ' + currency, this.goalId.find('option:selected').text(), this.model.get('sum') + ' ' + currency)

        }
    },

    updateModel: function() {

        this.model.update({
            'sum': this.sum.val(),
            'avg_cpa': this.avgCpa.val(),
            'goal_id': this.goalId.val(),
            'bid': this.bid.val()
        });

        this.updateDisabled();

    },


    updateDomByModel: function() {
        var model = this.model,
            goals = model.get('campaign_goals'),
            goalId = model.get('goal_id');

        model.stateData = model.memento();

        !(+this.model.get('bid')) && this.model.set('bid', '');
        this.bid.val(this.model.view('bid'));

        !(+this.model.get('sum')) && this.model.set('sum', '');
        this.sum.val(this.model.view('sum'));

        this.avgCpa.val(this.model.view('avg_cpa'));

        this.updateGoalsSelect(goals, goalId);

        goalId && this.goalId.val(goalId);

        this.updateHint();

        if (this.hint == 'no-metrika' || this.hint == 'no-data') {

             this.elem('input').prop('disabled', true);
             this
                 .setMod(this.elem('p'), 'hidden', 'yes')
                 .setMod(this.elem('hint-no-metrika'), 'hidden', 'no');
         }


        this.hint && (this.hint == 'no-metrika' || this.hint == 'no-data') &&
            model.set('no_save', true);

    },

    updateHint: function(){
        var model = this.model,
            goals = model.get('campaign_goals'),
            goalId = model.get('goal_id'),
            goal = goals ? goals[goalId] || {} : {},
            hint;

        if (!goals || model.get('all_goals_deleted') || model.get('all_counters_deleted'))
            hint = 'no-metrika';


        else if (model.get('count_all_' + this.goalsWhere + 'goals') < MIN_GOALS_ON_CAMPAIGN && goalId === "")
            hint = 'no-data';

        else if (goalId !== "" && (goal.goal_status == 'Deleted' || goal.counter_status == 'Deleted'))
            hint = 'goal-deleted';

        else if (goalId !== "" && goal[this.goalsWhere + 'goals_count'] < MIN_GOALS_ON_CAMPAIGN)
            hint = 'decrease-goal';

        else if (model.get('compaign_domains_count') > 2)
            hint = 'domains-count';

        else if (model.get('cpa_deviation'))
            hint = 'cpa-deviation';

        else if (model.get('apc_deviation'))
            hint = 'apc-deviation';


        else hint = '';

        this.setMod(this.elem('hints'), 'mod', this.hint = hint);
    },

    updateDisabled: function() {

        this
            .setMod(this.elem('bid-container'), 'disabled', this.bid.val() ? 'no' : 'yes' )
            .setMod(this.elem('sum-container'), 'disabled', this.sum.val() ? 'no' : 'yes' );
    }


}, {
    live: true
});
