BEM.blocks['b-model'].register('b-strategy-autobudget-roi', {

    fields: {
        'no_save': { type: 'flag', 'default': false },
        'roi_coef': { type: 'number', precision: 2, 'default': '', defaultView: '' },
        'reserve_return': { type: 'number' },
        'sum': { type: 'number', precision: 2, 'default': '', defaultView: '' },
        'bid': { type: 'number', precision: 2, 'default': '', defaultView: '' },
        'goal_id': { type: 'string' },
        'profitability': {
            type: 'number',
            precision: 2,
            'default': '',
            defaultView: ''
        },
        'currency': { type: 'const', 'default': 'YND_FIXED' },

        'all_goals_deleted': { type: 'flag' },
        'count_all_goals': { type: 'number' },
        'count_all_context_goals': { type: 'number' },
        'compaign_domains_count': { type: 'number', precision: 0 },
        'campaign_goals': { type: 'const', 'default': {} }

    },

    validateRules: function() {
        var curr = get_currency(this.get('currency'));

        return {
            'no_save': {
                'list': [
                    {
                        id: 'check',
                        validator: function(value) { return !value },
                        text: iget('Невозможно подключить среднюю рентабельность инвестиций.')
                    }
                ]
            },
            'roi_coef': {
                'list': [
                    {
                        id: 'required',
                        name: 'required',
                        condition: function() { return !this.get('no_save') },
                        text: iget('Не указано значение рентабельности инвестиций')
                    },
                    {
                        id: 'min',
                        name: 'min',
                        value: -0.99,
                        text: iget('Рентабельность инвестиций должна быть больше -1')
                    },
                    {
                        id: 'format',
                        name: 'format',
                        text: iget('Неверно указано значение рентабельности инвестиций')
                    }
                ]
            },
            'sum': {
                'list': [
                    {
                        id: 'min',
                        name: 'min',
                        value: curr.MIN_AUTOBUDGET,
                        text: iget("Недельный бюджет не может быть меньше %s", curr.MIN_AUTOBUDGET + ' ' + curr.name)
                    },
                    {
                        id: 'max',
                        name: 'max',
                        value: curr.MAX_AUTOBUDGET,
                        text: iget("Указан слишком большой недельный бюджет")
                    }
                ]
            },
            'bid': {
                list: [
                    {
                        id: 'min',
                        name: 'min',
                        value: curr.MIN_AUTOBUDGET_AVG_PRICE,
                        text: iget('Максимальная цена клика должна быть больше или равна %s', curr.MIN_AUTOBUDGET_AVG_PRICE + ' ' + curr.name)
                    },
                    {
                        id: 'max',
                        name: 'max',
                        value: curr.MAX_PRICE,
                        text: iget('Максимальная цена клика должна быть меньше или равна %s', curr.MAX_PRICE + ' ' + curr.name)
                    },
                    {
                        id: 'maxfield',
                        name: 'max',
                        value: function() { return this.get('sum') - 0.01 },
                        condition: function() { return this.get('sum') > 0 },
                        text: iget('Недельный бюджет должен быть больше максимальной цены клика.')
                    }
                ]
            },
            'profitability': {
                list: [
                    {
                        id: 'min',
                        name: 'min',
                        value: 0,
                        text: iget('Процент себестоимости должен быть указан в пределах от 0 до 100')
                    },
                    {
                        id: 'max',
                        name: 'max',
                        value: 100,
                        text: iget('Процент себестоимости должен быть указан в пределах от 0 до 100')
                    }
                ]
            }
        }
    }
});

BEM.DOM.decl({ name: 'b-strategy-autobudget-roi', baseBlock: 'b-strategy-autobudget' }, {
    onSetMod: {
        'js': function() {
            var _this = this;

            this.initConsts();
            this.initModel();
            this.bindErrorEvents();

            this.model.set('profitability', this.model.get('profitability'));

            this.goalsWhere = this.params.where == 'search' ? '' : 'context_';
            this.bid = this.elem('bid');
            this.roiCoef = this.elem('roi-coef');
            this.goalId = this.elem('goal-select');
            this.reserveReturn = this.elem('reserve-return');
            this.profitability = this.elem('profitability');
            this.sum = this.elem('sum');
            this.inputs = this.sum
                .add(this.roiCoef)
                .add(this.bid)
                .add(this.profitability);
            this.selects = this.reserveReturn
                .add(this.goalId)

            this.model
                .onField('roi_coef', 'change', $.debounce(this.updateDomByModel, 100), this)
                .onField('reserveReturn', 'change', this.updateDomByModel, this)
                .onField('bid', 'change', this.updateDomByModel, this)
                .onField('goal_id', 'change', this.updateDomByModel, this)
                .onField('sum', 'change', this.updateDomByModel, this)
                .onField('profitability', 'change', this.updateDomByModel, this);

            this.bindTo(this.inputs, 'change', this.updateModel, this);
            this.bindTo(this.selects, 'change', this.updateModel, this);


            this.sum
                .add(this.bid)
                .add(this.profitability)
                    .keyup($.debounce(function() { _this.updateDisabled(); }, 100)
                );

            this.updateDomByModel();

            this.updateDisabled();

        }
    },

    getStrategyData: function() {
        var model = this.model,
            currency = model.get('currency'),
            strategy = {
                name: 'autobudget-roi',
                roi_coef: model.get('roi_coef'),
                reserve_return: model.get('reserve_return'),
                sum: model.get('sum'),
                bid: model.get('bid'),
                goal_id: model.get('goal_id'),
                profitability: model.get('profitability')
            },
            values = {
                roiCoef: strategy.roi_coef,
                reserveReturn: strategy.reserve_return + '%',
                sum: format_sum_of_money(currency, strategy.sum),
                bid: format_sum_of_money(currency, strategy.bid),
                goalName: this.goalId.find('option:selected').text(),
                profitability: strategy.profitability + '%'
            },
            state = [];

        model.stateData = model.memento();

        strategy.sum && state.push('sum');
        strategy.bid && state.push('bid');
        strategy.goal_id != 0 && state.push('goal');
        strategy.profitability && state.push('profitability');

        return {
            strategy: strategy,
            description: {
                title: this.params.title,
                text: this.label(values)[state.join('-') || 'default']
            }
        }
    },

    label: function(values) {
        return {
            'default': iget('Удерживать рентабельность инвестиций на уровне %s по всем целям, возвращать в рекламу %s сэкономленного бюджета',
                values.roiCoef, values.reserveReturn),

            'goal': iget('Удерживать рентабельность инвестиций на уровне %s по цели «%s», возвращать в рекламу %s сэкономленного бюджета',
                values.roiCoef, values.goalName, values.reserveReturn),

            'sum': iget('Удерживать рентабельность инвестиций на уровне %s по всем целям, возвращать в рекламу %s сэкономленного бюджета, при недельном бюджете не более %s',
                values.roiCoef, values.reserveReturn, values.sum),

            'sum-bid': iget('Удерживать рентабельность инвестиций на уровне %s по всем целям, возвращать в рекламу %s сэкономленного бюджета, при недельном бюджете не более %s, при максимальной ставке не более %s',
                values.roiCoef, values.reserveReturn, values.sum, values.bid),

            'sum-goal': iget('Удерживать рентабельность инвестиций на уровне %s по цели «%s», возвращать в рекламу %s сэкономленного бюджета, при недельном бюджете не более %s',
                values.roiCoef, values.goalName, values.reserveReturn, values.sum),

            'sum-goal-profitability': iget('Удерживать рентабельность инвестиций на уровне %s по цели «%s», возвращать в рекламу %s сэкономленного бюджета, при недельном бюджете не более %s, учитывать, что %s доходов является себестоимостью товаров или услуг',
                values.roiCoef, values.goalName, values.reserveReturn, values.sum, values.profitability),

            'sum-profitability': iget('Удерживать рентабельность инвестиций на уровне %s по всем целям, возвращать в рекламу %s сэкономленного бюджета, при недельном бюджете не более %s, учитывать, что %s доходов является себестоимостью товаров или услуг',
                values.roiCoef, values.reserveReturn, values.sum, values.bid, values.profitability),

            'sum-bid-goal': iget('Удерживать рентабельность инвестиций на уровне %s по цели «%s», возвращать в рекламу %s сэкономленного бюджета, при недельном бюджете не более %s, при максимальной ставке не более %s',
                values.roiCoef, values.goalName, values.reserveReturn, values.sum, values.bid),

            'sum-bid-goal-profitability': iget('Удерживать рентабельность инвестиций на уровне %s по цели «%s», возвращать в рекламу %s сэкономленного бюджета, при недельном бюджете не более %s, при максимальной ставке не более %s, учитывать, что %s доходов является себестоимостью товаров или услуг',
                values.roiCoef, values.goalName, values.reserveReturn, values.sum, values.bid, values.profitability),

            'sum-bid-profitability': iget('Удерживать рентабельность инвестиций на уровне %s по всем целям, возвращать в рекламу %s сэкономленного бюджета, при недельном бюджете не более %s, при максимальной ставке не более %s, учитывать, что %s доходов является себестоимостью товаров или услуг',
                values.roiCoef, values.reserveReturn, values.sum, values.bid, values.profitability),

            'bid': iget('Удерживать рентабельность инвестиций на уровне %s по всем целям, возвращать в рекламу %s сэкономленного бюджета, при максимальной ставке не более %s',
                values.roiCoef, values.reserveReturn, values.bid),

            'bid-goal': iget('Удерживать рентабельность инвестиций на уровне %s по цели «%s», возвращать в рекламу %s сэкономленного бюджета, при максимальной ставке не более %s',
                values.roiCoef, values.goalName, values.reserveReturn, values.bid),

            'bid-profitability': iget('Удерживать рентабельность инвестиций на уровне %s по всем целям, возвращать в рекламу %s сэкономленного бюджета, при максимальной ставке не более %s, учитывать, что %s доходов является себестоимостью товаров или услуг',
                values.roiCoef, values.reserveReturn, values.bid, values.profitability),

            'bid-goal-profitability': iget('Удерживать рентабельность инвестиций на уровне %s по цели «%s», возвращать в рекламу %s сэкономленного бюджета, при максимальной ставке не более %s, учитывать, что %s доходов является себестоимостью товаров или услуг',
                values.roiCoef, values.goalName, values.reserveReturn, values.bid, values.profitability),

            'profitability': iget('Удерживать рентабельность инвестиций на уровне %s по всем целям, возвращать в рекламу %s сэкономленного бюджета, учитывать, что %s доходов является себестоимостью товаров или услуг',
                values.roiCoef, values.reserveReturn, values.profitability),

            'goal-profitability': iget('Удерживать рентабельность инвестиций на уровне %s по цели «%s», возвращать в рекламу %s сэкономленного бюджета, учитывать, что %s доходов является себестоимостью товаров или услуг',
                values.roiCoef, values.goalName, values.reserveReturn, values.profitability)

        }
    },

    updateModel: function() {

        this.model.update({
            'sum': this.sum.val(),
            'roi_coef': this.roiCoef.val(),
            'reserve_return': this.reserveReturn.val(),
            'goal_id': this.goalId.val(),
            'profitability': this.profitability.val(),
            'bid': this.bid.val()
        });

        this.updateDisabled();

    },


    updateDomByModel: function() {
        var model = this.model,
            goals = model.get('campaign_goals'),
            goalId = model.get('goal_id');

        model.stateData = model.memento();

        this.roiCoef.val(this.model.view('roi_coef'));

        !(+this.model.get('bid')) && this.model.set('bid', '');
        this.bid.val(this.model.view('bid'));

        !(+this.model.get('sum')) && this.model.set('sum', '');
        this.sum.val(this.model.view('sum'));

        !(+this.model.get('profitability')) && this.model.set('profitability', '');
        this.profitability.val(this.model.view('profitability'));

        this.reserveReturn.val(this.model.get('reserve_return').toString());

        this.updateGoalsSelect(goals, goalId);

        goalId && this.goalId.val(goalId);

        this.updateHint();

        if (this.hint == 'no-metrika' || this.hint == 'no-data') {

             this.elem('input').prop('disabled', true);
             this
                 .setMod(this.elem('p'), 'hidden', 'yes')
                 .setMod(this.elem('hint-no-metrika'), 'hidden', 'no');
         }


        this.hint && (this.hint == 'no-metrika' || this.hint == 'no-data') &&
            model.set('no_save', true);

    },

    updateHint: function() {
        var model = this.model,
            goals = model.get('campaign_goals'),
            goalId = model.get('goal_id'),
            goal = goals ? goals[goalId] || {} : {},
            hint;

        if (!goals || model.get('all_goals_deleted') || model.get('all_counters_deleted'))
            hint = 'no-metrika';


        else if (model.get('count_all_' + this.goalsWhere + 'goals') < MIN_GOALS_ON_CAMPAIGN && goalId === "")
            hint = 'no-data';

        else if (goalId !== "" && (goal.goal_status == 'Deleted' || goal.counter_status == 'Deleted'))
            hint = 'goal-deleted';

        else if (goalId !== "" && goal[this.goalsWhere + 'goals_count'] < MIN_GOALS_ON_CAMPAIGN)
            hint = 'decrease-goal';

        else if (model.get('compaign_domains_count') > 2)
            hint = 'domains-count';

        else if (model.get('cpa_deviation'))
            hint = 'cpa-deviation';

        else if (model.get('apc_deviation'))
            hint = 'apc-deviation';


        else hint = '';

        this.setMod(this.elem('hints'), 'mod', this.hint = hint);
    },

    updateDisabled: function() {

        this
            .setMod(this.elem('bid-container'), 'disabled', this.bid.val() ? 'no' : 'yes' )
            .setMod(this.elem('profitability-container'), 'disabled', this.profitability.val() ? 'no' : 'yes' )
            .setMod(this.elem('sum-container'), 'disabled', this.sum.val() ? 'no' : 'yes' );
    }


}, {
    live: true
});
