(function($){
    // стратегия "Недельный пакет кликов"
    BEM.blocks['b-model'].register('b-strategy-autobudget-week-bundle', {

        fields: {
            'limit_clicks': {type: 'number', precision: 0, 'default': '', defaultView: ''},
            'bid': {type: 'number', precision: 2, 'default': '', defaultView: ''},
            'avg_bid': {type: 'number', precision: 2, 'default': '', defaultView: ''},

            'currency': {type: 'const', 'default': 'YND_FIXED'}
        },

        validateRules: function(){
            var curr = get_currency(this.get('currency'));
            return {
                'limit_clicks': {
                    'list': [
                        { id: 'required', name: 'required', text: iget('Не указано количество кликов на неделю')},
                        { id: 'format', name: 'format', text: iget('Неверно указано количество кликов')},
                        {
                            id: 'min', name: 'min', value: curr.MIN_AUTOBUDGET_CLICKS_BUNDLE,
                            text: iget('Количество кликов на неделю должно быть не менее %s', curr.MIN_AUTOBUDGET_CLICKS_BUNDLE)
                        },
                        {
                            id: 'max', name: 'max', value: curr.MAX_AUTOBUDGET_CLICKS_BUNDLE,
                            text: iget('Указано слишком большое количество кликов')
                        }
                    ]
                },
                'bid': {
                    'list': [
                        {
                            id: 'min', name: 'min', value: curr.MIN_AUTOBUDGET_BID,
                            text: iget("Указана ставка меньше минимальной цены клика")
                        },
                        {
                            id: 'max', name: 'max', value: curr.MAX_AUTOBUDGET_BID,
                            text: iget("Указана ставка больше %s", curr.MAX_AUTOBUDGET_BID + ' ' + curr.name)
                        }
                    ],
                    'condition': function() { return !this.get('avg_bid') }
                },
                'avg_bid': {
                    'list': [
                        {
                            id: 'min', name: 'min', value: curr.MIN_AUTOBUDGET_AVG_PRICE,
                            text: iget("Средняя цена за клик должна быть не менее %s", curr.MIN_AUTOBUDGET_AVG_PRICE + ' ' + curr.name)
                        },
                        {
                            id: 'max', name: 'max', value: curr.MAX_AUTOBUDGET_BID,
                            text: iget("Средняя цена за клик не может превышать %s", curr.MAX_AUTOBUDGET_BID + ' ' + curr.name)
                        }
                    ],
                    'condition': function() { return !this.get('bid') }
                }
            }
        }
    });

    BEM.DOM.decl({name: 'b-strategy-autobudget-week-bundle', baseBlock: 'b-model-block'}, {
        onSetMod: {
            'js': function(){
                var _this = this;
                this.initConsts();
                this.initModel();
                this.bindErrorEvents();

                this.model
                    .on('reset', this.updateDomByModel, this)
                    .onField('avg_bid', 'change', this.onBidChange, this)
                    .onField('bid', 'change', this.onBidChange, this)
                    .onField('limit_clicks', 'change', this.onLimitChange, this);

                this
                    .bindTo('bid', 'change', this.updateDisabled, this)
                    .bindTo('bid', 'change', this.updateModel, this)
                    .bindTo('select', 'change', this.updateModel, this)
                    .bindTo('limit-clicks', 'change', this.updateModel, this);


                this.updateDomByModel();

            }
        },

        getStrategyData: function(){
            var model = this.model,
                strategy = {
                    name: 'autobudget-week-bundle',
                    limit_clicks: model.get('limit_clicks'),
                    bid: model.get('bid'),
                    avg_bid: model.get('avg_bid')
                },
                bid = strategy.bid || strategy.avg_bid;

            model.stateData = model.memento();

            return {
                strategy: strategy,
                description: {
                    title: this.params.title,
                    text: iget('Получать %s %s', strategy.limit_clicks,
                        common.inflector.pluralizeWord([iget('клик'), iget('клика'), iget('кликов')], strategy.limit_clicks)) +
                        (bid ?
                            ', ' +
                                iget('при %s не более %s',
                                    strategy.bid ? iget('максимальной ставке') : iget('средней цене клика за неделю'),
                                    bid + '&nbsp;' + format_currency(model.get('currency'))) :
                            '')
                }
            };
        },

        updateModel: function () {
            var notDigit = /[^\d.,/\-]*/g,
                bid = this.elem('bid').val().replace(notDigit, ''),
                isAvg = this.elem('select').val() == 'avg_bid',
                limitClicks = this.elem('limit-clicks').val().replace(notDigit, '');

            bid == '' && this.elem('bid').val('');
            limitClicks == '' && this.elem('limit-clicks').val('');

            this.model.update({
                avg_bid: isAvg ? bid : '',
                bid: !isAvg ? bid : '',
                limit_clicks: limitClicks
            });
        },


        updateDomByModel: function(){
            this.model.stateData = this.model.memento();

            this.onLimitChange();
            this.onBidChange();
            this.elem('select').val(!!this.model.get('avg_bid') ? 'avg_bid' : 'bid');
        },

        onBidChange: function () {
            var avgBid = this.model.get('avg_bid'),
                bid = this.model.get('bid'),
                isAvg = !!+avgBid,
                bidIsNum = +(isAvg ? avgBid : bid);

            this.elem('bid').val(bidIsNum ? this.model.view(isAvg ? 'avg_bid' : 'bid') : '');
            !bidIsNum && this.model.set(isAvg ? 'avg_bid' : 'bid', '');

            this.updateDisabled();
        },

        onLimitChange: function () {
            this.elem('limit-clicks').val(this.model.view('limit_clicks'));
        },

        updateDisabled: function () {
            // чтобы сразу в начале ввода значения активировать селект, не проверяем значение на то, число ли это
            var bid = this.elem('bid').val();

            this.elem('select').prop('disabled', !bid);
            this.toggleMod(this.elem('bid-container'), 'mod', 'disabled', !bid);
        }


    }, {
        live: true
    });

})(jQuery);
