(function($){
    BEM.blocks['b-model'].register('b-strategy-autobudget', {

        fields: {
            'compaign_domains_count': { type: 'number', precision: 0 },
            'all_counters_deleted': { type: 'flag' },

            'all_goals_deleted': { type: 'flag' },

            'count_all_goals': { type: 'number' },
            'count_all_context_goals': { type: 'number' },

            'no-save': { type: 'flag' },

            'campaign_goals': { type: 'const', 'default': {} },
            'goal_id': { type: 'string' },

            'sum': { type: 'number', precision: 2, 'default': '', defaultView: '' },
            'bid': { type: 'number', precision: 2, 'default': '', defaultView: '' },

            'currency': { type: 'const', 'default': 'YND_FIXED' }

        },

        validateRules: function(){
            var curr = get_currency(this.get('currency'));
            return {
                'sum': {
                    'list': [
                        { id: 'required', name: 'required', text: iget("Не указана сумма недельного бюджета")},
                        { id: 'format', name: 'format', text: iget("Неверно указана сумма недельного бюджета")},
                        {
                            id: 'min', name: 'min', value: curr.MIN_AUTOBUDGET,
                            text: iget("Недельный бюджет не может быть меньше %s", curr.MIN_AUTOBUDGET + ' ' + curr.name)
                        },
                        {
                            id: 'max', name: 'max', value: curr.MAX_AUTOBUDGET,
                            text: iget("Указан слишком большой недельный бюджет")
                        }
                    ]
                },
                'bid': {
                    'list': [
                        {
                            id: 'min', name: 'min', value: curr.MIN_AUTOBUDGET_BID,
                            text: iget("Указана ставка меньше минимальной цены клика")
                        },
                        {
                            id: 'max', name: 'max', value: curr.MAX_AUTOBUDGET_BID,
                            text: iget("Указана ставка больше %s", curr.MAX_AUTOBUDGET_BID + ' ' + curr.name)
                        },
                        {
                            id: 'maxfield', name: 'max', value: function() { return this.get('sum') },
                            text: iget("Недельный бюджет должен быть больше максимальной ставки")
                        }
                    ]
                }
            }
        }
    });

    BEM.DOM.decl({name: 'b-strategy-autobudget', baseBlock: 'b-model-block'}, {
        onSetMod: {
            'js': function(){
                var _this = this,
                    uniqName = $.identify();

                this.initConsts();
                this.initModel();
                this.bindErrorEvents();

                // DIRECT-15347
                // в зависимости от того где у нас выставлен автобюджет, на поиске или в сети
                // мы смотрим либо поле goals_count либо context_goals_count
                // а также count_all_goals или count_all_context_goals
                this.goalsWhere = this.params.where == 'search' ? '' : 'context_';

                this.model
                    .on('reset', function(){ _this.updateDomByModel() })
                    .onField('sum', 'change', function(){ this.onSumChange() }, this)
                    .onField('bid', 'change', function(){ this.onBidChange() }, this)
                    .onField('goal_id', 'change', function(){ this.onGoalChange() }, this);

                $.map(['clicks', 'conv'], function(el){
                    var radio = _this.elem('cpa-' + el).attr('name', uniqName);

                    _this.elem('cpa-' + el + '-label').click(function(){
                        !radio.prop('disabled') && radio.prop('checked', true).change();
                    });
                });

                this.elem('sum')
                    .add(this.elem('bid'))
                    .add(this.elem('cpa-clicks'))
                    .add(this.elem('cpa-conv'))
                    .add(this.elem('goal-select'))
                        .change(function(){ _this.updateModel() });

                this.elem('bid').keyup(function(){ _this.updateDisabled() });

                this.updateDomByModel();

            }
        },

        getStrategyData: function(){
            var model = this.model,
                stateData = model.stateData = model.memento(),
                currency = '&nbsp;' + format_currency(model.get('currency')),
                goal = this.getGoal(stateData.goal_id),
                strategy = {
                    name: 'autobudget',
                    bid: stateData.bid,
                    sum: stateData.sum,
                    goal_id: stateData.goal_id
                },
                warning = '';

            this.updateHint();

            if (this.hint == 'decrease-goal' || this.hint == 'goal-deleted') {
                warning =
                    '<a onclick="return OpenWindow(this.href, 700, 600);" href="' + get_help_url('weekly-budget-conversion') + '"' +
                        ' title="' +
                            (this.hint == 'decrease-goal' ?
                                iget('Снизилось количество целевых визитов') :
                                iget('Цель была удалена')) +
                        '">' +

                        '<img alt="?" width="10" height="10" border="0" src="/i/i-help.gif" />' +
                    '</a>';
            }

            return {
                strategy: strategy,
                description: {
                    title: this.params.title,
                    text: iget('Тратить %s', strategy.sum + currency) +
                        (strategy.bid ? ' ' + iget('при максимальной ставке %s', strategy.bid + currency) : '') +
                        ', ' +
                            (strategy.goal_id !== '' ?
                                strategy.goal_id == 0 || !goal ?
                                iget('получать максимальную конверсию по всем целям') :
                                iget('получать максимальную конверсию по цели') + '&nbsp;' +
                                '<span style="' + (warning ? 'color: red;' : '') + ' white-space: nowrap;">' +
                                    '&laquo;' +
                                        (strategy.goal_id == 0 || !goal ?
                                            this.elem('goal-select').find('option:selected').text() :
                                            goal.goal_name || '&mdash;') +
                                    '&raquo;' +
                                '</span>' +
                                '&nbsp;' + warning :
                                iget('получать максимум кликов'))
                }
            };
        },

        getGoal: function(goalId) {
            return this.model.get('campaign_goals')[goalId];
        },

        updateModel: function () {
            var notDigit = /[^\d.,/\-]*/g,
                bid = this.elem('bid').val().replace(notDigit, ''),
                sum = this.elem('sum').val().replace(notDigit, '');

            bid == '' && this.elem('bid').val('');
            sum == '' && this.elem('sum').val('');

            this.model.update({
                bid: bid,
                sum: sum,
                goal_id: this.elem('cpa-clicks').prop('checked') ? '' : this.elem('goal-select').val()
            });
        },


        updateDomByModel: function(){
            var model = this.model,
                goals = model.get('campaign_goals'),
                goalId = model.get('goal_id'),
                disabled = !goals ||
                    model.get('all_counters_deleted') || model.get('all_goals_deleted') ||
                    model.get('count_all_' + this.goalsWhere + 'goals') < MIN_GOALS_ON_CAMPAIGN, // DIRECT-15347
                goalSelect = this.elem('goal-select');


            model.stateData = model.memento();

            this.onSumChange();
            this.onBidChange();


            this.elem('cpa-clicks').prop('checked', !goalId);

            this.elem('cpa-conv')
                .prop('checked', !!goalId)
                .prop('disabled', disabled);

            this.updateGoalsSelect(goals, goalId);

            goalSelect.prop('disabled', disabled);
            goalId && goalSelect.val(goalId);

            this.toggleMod(this.elem('goal-select-block'), 'mod', 'disabled', !!disabled);

            this.onGoalChange();

            this.updateHint();

        },

        onSumChange: function () {
            this.elem('sum').val(this.model.view('sum'));
        },

        onBidChange: function () {
            var bidIsNum = +this.model.get('bid');
            this.elem('bid').val(bidIsNum ? this.model.view('bid') : '');
            !bidIsNum && this.model.set('bid', '');

            this.updateDisabled();
        },

        updateDisabled: function(){
            this.toggleMod(this.elem('bid-label'), 'mod', 'disabled', !this.elem('bid').val());
        },

        onGoalChange: function() {
            var isConvChecked = !!this.elem('cpa-conv').prop('checked');

            this.elem('goal-select').prop('disabled', !isConvChecked);
            this.toggleMod(this.elem('goal-select-label'), 'mod', 'disabled', !isConvChecked);
        },


        updateGoalsSelect: function(goals, currentGoalId) {
            var goalsCount = this.goalsWhere + 'goals_count';

            function getGoalName(goal) {
                var name = goal.goal_name;

                if (!name) return '&mdash;';

                // задаём длину описания цели (раньше резалось на довольно коротком значении)
                var NAME_LENGTH = 100;

                // html в goal_name эскейпится на сервере
                return name.substr(0, NAME_LENGTH) + (goal.goal_name.length > NAME_LENGTH ? '...' : '') +
                    (goal.status == 'Deleted' ? '(' + iget('удалена') + ')' : '') +
                    (goal[goalsCount] < MIN_GOALS_ON_CAMPAIGN ? '(' + iget('мало данных') + ')' : '');
            }



            var options = '<option value="0">' + iget('всем целям') + '</option>';

            goals && $.each(goals, function(i, v){
                if (v.counter_status == 'Active' && v.goal_status == 'Active' || i == currentGoalId) {

                    options +=
                        '<option value="' + i + '"' +
                            (v.counter_status == 'Deleted' || v.goal_status == 'Deleted' ? ' style="color: red;"' : '') +
                            (v[goalsCount] < MIN_GOALS_ON_CAMPAIGN ? ' disabled' : '') + '>' +

                            getGoalName(v) +
                        '</option>';
                }
            });

            this.elem('goal-select').length && this.elem('goal-select').html(options);
        },

        // подсказки-варнинги
        updateHint: function(){
            var model = this.model,
                goals = model.get('campaign_goals'),
                goalId = model.get('goal_id'),
                goal = goals ? goals[goalId] || {} : {},
                hint;

            if (!goals || model.get('all_goals_deleted') || model.get('all_counters_deleted'))
                hint = 'no-metrika';


            else if (model.get('count_all_' + this.goalsWhere + 'goals') < MIN_GOALS_ON_CAMPAIGN && goalId === "")
                hint = 'no-data';

            else if (goalId !== "" && (goal.goal_status == 'Deleted' || goal.counter_status == 'Deleted'))
                hint = 'goal-deleted';

            else if (goalId !== "" && goal[this.goalsWhere + 'goals_count'] < MIN_GOALS_ON_CAMPAIGN)
                hint = 'decrease-goal';

            else if (model.get('compaign_domains_count') > 2)
                hint = 'domains-count';

            else hint = '';

            this.setMod(this.elem('hints'), 'mod', this.hint = hint);
        }

    }, {
        live: true
    });

})(jQuery);
