(function($){
var iModelManager = BEM.blocks['i-models-manager'];

BEM.DOM.decl('b-strategy-choose-popup-content', {
    onSetMod: {
        'js': function(){
            var popupa = this.popupa = this.findBlockOutside('b-popupa'),
                _this = this;

            this.tabbedPane = this.findBlockInside('b-tabbed-pane')
                .on('current', this.checkCurrentRadio, this);

            popupa.on('show', this.checkCurrentRadio, this);

            popupa.saveButton = this.findBlockInside('save', 'b-form-button').on('click', this.saveStrategy, this);

            popupa.cancelButton = this.findBlockInside('cancel', 'b-form-button').on('click', function(){
                popupa.hide();
            });

            // дёргаем клик, чтобы отрисовать надписи, и сохранить в хидден инпуты данные о стратегии (и дневном бюджете)
            this.saveStrategy('', true);


            // при резете, делаем ещё раз "инит"
            popupa.model.on('reset', function(){
                // пересохраняем стратегию после события reset, чтобы все данные успели обновиться
                this.afterCurrentEvent(function(){
                    this.saveStrategy('', true);
                });
            }, this);


            // слушаем изменения моделей стратегий (всех кроме 'default' т. к. для неё модели нету)
            // чтобы стирать сообщение об ошибке сохранения стратегии, если пользователь начал исправлять данные
            $.map(this.popupa.tabToStratList.slice(1), function(strat){
                $.map(['search', 'net'], function(where){
                    iModelManager
                        .get('campaign&strategy:' + where, 'b-strategy-' + strat)
                        .on('quick-change', _this.clearErrors, _this)
                })
            });

            iModelManager.get('campaign&day-budget', 'b-day-budget').on('quick-change', _this.clearErrors, _this);

            iModelManager.get('campaign&strategy', 'b-strategy-different-places')
                .onField('search_strategy', 'change', this.clearErrors, this)
                .onField('net_strategy', 'change', this.clearErrors, this);

            popupa.on('revertCurrentBlock', function(){
                var current = this.getCurrent(),
                    blocksForRevert = [current.block, this.popupa.dayBudget];

                if (current.strategy == 'different-places')
                    $.map(['search', 'net'], function(where){
                        blocksForRevert
                            .push(current.block.stratBlocks[where][current.model.stateData[where + '_strategy']]);
                    });

                $.map(blocksForRevert, function(block){
                    var model = block && block.model;

                    model &&
                        model.isDataChanged(model.stateData) &&
                            model.update(model.stateData) &&
                                block.updateDomByModel &&
                                    block.updateDomByModel();
                });

            }, this);

        }
    },


    // чекаем радиобаттон
    checkCurrentRadio: function(){
        this.clearErrors();
        this.tabbedPane.currentTab.find('input').prop('checked', true)
    },

    // получаем текущую выбранную панель/стратегию/блок/модель
    getCurrent: function(){
        var tabbedPane = this.tabbedPane,
            currentPane = tabbedPane.getPanel('state', 'current'),
            currentStrat = this.popupa.tabToStratList[tabbedPane.getPanel().index(currentPane)],
            currentStratBlock = tabbedPane.findBlockInside(currentPane, 'b-strategy-' + currentStrat),
            currentStratModel;

        currentStratBlock && (currentStratModel = currentStratBlock.model);

        return {
            pane: currentPane,
            strategy: currentStrat,
            block: currentStratBlock,
            model: currentStratModel
        }
    },

    clearErrors: function() {
        this.elem('errors').html('');
    },

    saveStrategy: function(e, init){
        var popupa = this.popupa,
            dayBudget = popupa.dayBudget,
            phrChangeWarn = BEM.blocks['b-phrases-changing-warning'];

        popupa.saveButton.domElem.focus();
        if ($.isFunction(phrChangeWarn) && !this.params.noConfirm) {
            if (phrChangeWarn.saveChanges()) {
                return;
            } else {
                phrChangeWarn.unbindEvents()
            }
        }
        // при ините (когда попап не открыт) переключаем tabbedPane на текущую стратегию
        !popupa.isShowed() && popupa.trigger('selectCurrentTab');

        var strategy = { name: '', search: { name: 'default' }, net: { name: 'default' } },
            strategyData = {
                strategy: strategy,
                description: { title: iget('Наивысшая доступная позиция') }
            },
            current = this.getCurrent();
        if (!init && current.model && !current.model.validateModel()) {
            // ошибки в стратегии
            return false;
        } else if (!init && dayBudget && dayBudget.getMod('mod') != 'disabled' && !dayBudget.model.validateModel()) {
            // ошибки в дневном бюджете
            return false;
        } else {
            if (current.strategy != 'different-places') {
                if (current.block && current.block.getStrategyData) {
                    var currData = current.block.getStrategyData();
                    strategy.search = currData.strategy;
                    strategyData.description = currData.description;
                }
            } else $.extend(true, strategyData, current.block.getStrategyData());

            // из-за того, что в BEM разделителем слов явлется "-", а на сервере разделитель "_" - делаем replace
            strategy.name = strategy.name.replace(/-/g, '_');
            strategy.search.name = strategy.search.name.replace(/-/g, '_');
            strategy.net.name = strategy.net.name.replace(/-/g, '_');

            popupa.trigger('saveStrategy', {strategyData: strategyData, init: init});
        }
    }

}, {
    live: true
});

})(jQuery);
