(function($){

BEM.DOM.decl('b-strategy-choose', {
    onSetMod: {
        'js': function(){
            var model = this.model = BEM.blocks['i-models-manager'].get('campaign', 'campaign-strategy'),
                timeTargetModel = BEM.blocks['i-models-manager'].get('campaign', 'b-time-targeting'),
                isAjax = this.params.ajax,
                _this = this,
                isPopupShow = false;

            model.stateData = model.memento();
            timeTargetModel.set('is_autobudget', model.get('is_autobudget'));

            // при резете, пересохраняем stateData
            model
                .on('reset', function(){
                    model.stateData = model.memento();
                    timeTargetModel.set('is_autobudget', model.get('is_autobudget'));
                })
                .onField('is_autobudget', 'change', function() {
                    timeTargetModel.set('is_autobudget', model.get('is_autobudget'));
                });

            this.findBlockOn(this.elem('switcher'), 'b-form-button')
                .on('click', function() {
                    if (this._closing) return;

                    this.getPopup().show(this.elem('switcher'));
                }, this);

            BEM.blocks['b-campaign-edit-block'].on('open', function(e, elem) {
                if (elem != _this && _this.getPopup().isShowed()) {
                    _this.getPopup().hide();
                }
            }, this);

            this.getPopup();
        }
    },

    getPopup: function() {
        if (this.popupa) return this.popupa;

        this.popupa = this.findBlockInside('b-popupa');

        var _this = this, model = this.model ,
            tabToStratList = this.params.tabToStratList,
            stratToTabList = this.params.stratToTabList;

        this.popupa.tabbedPane = this.popupa.findBlockInside('b-tabbed-pane');

        this.dayBudget = this.popupa.findBlockInside('b-day-budget');

        // блок подсказок про переход С и НА независимое управление тоже один на все табы
        this.diffPlacesHints = this.elem('diff-places-hints');

        $.extend(this.popupa, {
            model: model,
            strategyChoose: this,
            tabToStratList: tabToStratList,
            dayBudget: this.dayBudget
        });

        this.popupa.tabbedPane
            .on('current', function(e, data){
                this.trigger('currentStrat', this.currStrat = tabToStratList[this.getPanel().index(data.current)]);
            }, this.popupa.tabbedPane)

            .on('currentStrat', function(e, currStrat){
                var mod = 'disabled',
                    diffPl = 'different-places';

                // показываем необходимую подсказку про переход ОТ или К стратегии независимого управления
                if (model.stateData.name == diffPl) {
                    currStrat != model.stateData.name &&
                        currStrat.indexOf('autobudget') == -1 &&
                    (mod = 'from');
                } else currStrat == diffPl && (mod = 'to');

                _this.setMod(_this.diffPlacesHints, 'mod', mod);
                // случай когда на вкладке независимого управления выставляем автобюджет в РСЯ
                // обрабатывается в блоке независимого управления
            });



        this.popupa
            .on('selectCurrentTab', function(){
                this.popupa.tabbedPane.selectByIndex(stratToTabList[(model.get('name') || model.get('search_strategy')).replace(/_/g, '-')]);

                this.popupa.trigger('revertCurrentBlock');
            }, this)

            .on('hide', function(){ this.popupa.trigger('selectCurrentTab') }, this)

            .on('outside-click', function() {
                this.afterCurrentEvent(function() {
                    this.popupa.hide();
                    this._closing = false;
                }, this);

                this._closing = true;

                return false;
            }, this)

            .on('show', function() {
                BEM.blocks['b-campaign-edit-block'].trigger('open', this);
            }, this)

            .on('saveStrategy', function(e, data){
                if (data.init || !this.params.ajax) {
                    this.saveStrategy(e, data);
                } else {
                    var phrasesChangingWarning = BEM.blocks['b-phrases-changing-warning'];
                    if ($.isFunction(phrasesChangingWarning)) {
                        if (phrasesChangingWarning.saveChanges()) {
                            return;
                        } else {
                            phrasesChangingWarning.unbindEvents()
                        }
                    }
                    this.setLoading(true);

                    var errorMsg = iget('Не удалось сохранить стратегию'),
                        ajaxData = {
                            cid: this.params.cid,
                            cmd: 'ajaxSaveAutobudget',
                            ulogin: this.params.ulogin,
                            json_strategy: $.stringify(data.strategyData.strategy)
                        };

                    if (this.dayBudget && !this.dayBudget.hasMod('mod', 'disabled'))
                        ajaxData.json_day_budget = $.stringify(this.dayBudget.getDayBudgetData().dayBudget);

                    $.ajax({
                        url: SCRIPT,
                        dataType: 'json',
                        type: 'POST',
                        data: ajaxData,
                        success: function(response) {
                            if (response.success) {
                                _this.saveStrategy(e, data);
                                location.reload();
                            } else {
                                alert(response.error || errorMsg);
                                _this.setLoading(false);
                            }
                        },
                        error: function() {
                            alert(errorMsg);
                            _this.setLoading(false);
                        }
                    });
                }
            }, this)
            ._getUnder(); // дёргаем эту функцию, чтобы попап вывалился наружу

        //инициализируем содержимое попапа
        $.map(['b-strategy-autobudget', 'b-strategy-choose-popup-content', 'b-strategy-min-price',
            'b-strategy-no-premium', 'b-strategy-autobudget-avg-click', 'b-strategy-autobudget-avg-cpa',
            'b-strategy-autobudget-roi', 'b-strategy-different-places', 'b-strategy-autobudget-week-bundle'
        ], function(name) { _this.popupa.findBlockInside(name); });

        return this.popupa;

    },

    setLoading: function(state){
        this.getPopup().saveButton
            .toggleMod('disabled', 'yes', state)
            .elem('text').text(function(i, v){
                var hellip = '...';
                return state ? v + hellip : v.replace(hellip, '');
            });

        this.getPopup().cancelButton.toggleMod('disabled', 'yes', state)
    },



    saveStrategy: function(e, data){
        var current = this.elem('current'),
            isAjax = this.params.ajax,
            stratData = data.strategyData,
            strategy = stratData.strategy,
            dayBudgetData = this.dayBudget && !this.dayBudget.hasMod('mod', 'disabled') && this.dayBudget.getDayBudgetData();

        !isAjax && current.val($.stringify(strategy));

        strategy.search_strategy = strategy.search.name;
        strategy.net_strategy = strategy.net.name;
        this.model.update(strategy);

        if (data.init || !isAjax) {
            // Пишем надписи про выбранную стратегию
            // Название стратегии
            this.elem('current-title').text(stratData.description.title);

            this.setText(data);
            // сохраняем значение дневного бюджета
            !isAjax &&
                this.elem('day-budget')
                    .attr('name', dayBudgetData ? 'json_day_budget' : '')
                    .val(dayBudgetData ? $.stringify(dayBudgetData.dayBudget) : '');

            !isAjax && this.getPopup().hide();
        }
    },

    setText: function(data) {
        var currentParams = '',
            isAjax = this.params.ajax,
            stratData = data.strategyData,
            dayBudgetData = this.dayBudget && !this.dayBudget.hasMod('mod', 'disabled') && this.dayBudget.getDayBudgetData();

        // рисуем текст с подробностями выбранных параметров стратегии + дневной бюджет
        currentParams =
            ((stratData.description.text || '') + (dayBudgetData && !isAjax ? dayBudgetData.text : ''))
                // для версии на странице кампании заменяем переносы строк на пробелы
                .replace(isAjax ? /<br\/>|<br>/g : '', isAjax ? ' ' : '');
        this.elem('current-params').html(currentParams).toggle(!!currentParams);
    }
}, {
    getText: function() {

    }

});

})(jQuery);
