(function($){
    // стратегия "Независимое управление для разных типов площадок"
    BEM.blocks['b-model'].register('b-strategy-different-places', {

        changesTimeout: 10,

        fields: {
            'search_strategy': {type: 'string', 'default': 'default'},
            'net_strategy': {type: 'string', 'default': 'maximum-coverage'}
        },

        childModels: {
            'b-strategy-min-price': {path: 'campaign&strategy:search', condition: function() {
                return this.get('search_strategy') == 'min-price'
            }},
            'b-strategy-no-premium': {path: 'campaign&strategy:search', condition: function() {
                return this.get('search_strategy') == 'no-premium'
            }},
            'b-strategy-autobudget': {path: 'campaign&strategy:net', condition: function() {
                return this.get('net_strategy') == 'autobudget'
            }},
            'b-strategy-autobudget-avg-click': {path: 'campaign&strategy:net', condition: function() {
                return this.get('net_strategy') == 'autobudget-avg-click'
            }},
            'b-strategy-autobudget-avg-cpa': {path: 'campaign&strategy:net', condition: function() {
                return this.get('net_strategy') == 'autobudget-avg-cpa'
            }},
            'b-strategy-autobudget-roi': {path: 'campaign&strategy:net', condition: function() {
                return this.get('net_strategy') == 'autobudget-roi'
            }},
            'b-strategy-autobudget-week-bundle': {path: 'campaign&strategy:net', condition: function() {
                return this.get('net_strategy') == 'autobudget-week-bundle'
            }}
        }

    });

    BEM.DOM.decl({name: 'b-strategy-different-places', baseBlock: 'b-model-block'}, {
        onSetMod: {
            'js': function(){
                var popupa = this.popupa = this.findBlockOutside('b-popupa'),
                    dayBudget = popupa.dayBudget,
                    strategyChoose = popupa.strategyChoose,
                    diffPlacesHintMod,
                    diffPlacesStrat = this.params.diffPlacesStrat,
                    _this = this,
                    diffPl = 'different-places';



                this.initConsts();
                this.initModel();
                this.bindErrorEvents();

                this.stratBlocks = { search: {}, net: {} };

                this.model.on('reset', function(){ _this.updateDomByModel() });

                popupa.tabbedPane.on('currentStrat', function(e, currStrat){
                    currStrat == diffPl && this.elem('net-select').change();

                    diffPlacesHintMod = strategyChoose.getMod(strategyChoose.diffPlacesHints, 'mod');
                }, this);


                this
                    .on('search-strategy-change', function(e, strat){
                        var isStop = strat == 'stop',
                            netSelect = this.elem('net-select'),
                            defaultNetStrat = diffPlacesStrat.net[0].blockName;

                        !isStop && netSelect.val() != defaultNetStrat && netSelect.val(defaultNetStrat).change();
                        this.toggleMod(netSelect, 'mod', '', 'disabled', isStop);
                        this.toggleMod(this.elem('net-default'), 'mod', 'disabled', '', isStop);
                    }, this)

                    .on('net-strategy-change', function(e, strat){
                        var isAutobudget = strat.indexOf('autobudget') != -1;

                        dayBudget &&
                            popupa.tabbedPane.currStrat == diffPl &&
                                dayBudget.toggleMod('mod', 'disabled', isAutobudget);

                        // в случае выставления автобюджета в сети, прячем подсказку
                        strategyChoose.setMod(strategyChoose.diffPlacesHints, 'mod',
                            isAutobudget || diffPlacesHintMod == 'from' ? 'disabled' : diffPlacesHintMod);
                    });

                $.map(['search', 'net'], function(where){
                    _this.elem(where + '-select').change(function(){
                        var currStrat = this.value;
                        _this.model.set(where + '_strategy', currStrat);

                        $.map(diffPlacesStrat[where], function(el){
                            var name = el.blockName;
                            (_this.stratBlocks[where][name] ||
                                (_this.stratBlocks[where][name] = _this.findBlockInside(where + '-blocks', 'b-strategy-' + name)))
                                    .toggleMod('mod', '', 'disabled', currStrat == name);
                        });

                        _this.trigger(where + '-strategy-change', currStrat);
                    });
                });


                // init
                this.updateDomByModel();

            }
        },

        updateDomByModel: function(){
            var _this = this,
                model = this.model;

            model.stateData = model.memento();

            $.map(['search', 'net'], function(where){
                _this.elem(where + '-select')
                    .val(model.stateData[where + '_strategy'])
                    .change();
            });
        },

        getStrategyData: function(){
            var _this = this,
                data = {
                    strategy: { name: 'different_places', search: {}, net: {} },
                    description: {
                        title: this.params.title,
                        text: ''
                    }
                };

            this.model.stateData = this.model.memento();

            $.map(['search', 'net'], function(where){
                var currentSelect = _this.elem(where + '-select'),
                    currentStratName = currentSelect.val(),
                    currentStratBlock = _this.stratBlocks[where][currentStratName],
                    currentStratData = currentStratBlock.getStrategyData && currentStratBlock.getStrategyData();

                currentStratData ?
                    data.strategy[where] = currentStratData.strategy :
                    data.strategy[where].name = currentStratName;

                data.description.text +=
                    '<div>' +
                        _this.elem(where + '-title').text() + ' ' +
                        (currentStratData ?
                            currentStratData.description.title + '. ' + currentStratData.description.text :
                            currentSelect.find('option:selected').text()) +
                    '</div>';
            });

            return data;
        }

    }, {
    live: true
    });

})(jQuery);
