(function($){
    // стратегия "Показ в блоке по минимальной цене"
    BEM.blocks['b-model'].register('b-strategy-min-price', {

        fields: {
            'place': {type: 'string', 'default': 'premium'}
        }

    });

    BEM.DOM.decl({name: 'b-strategy-min-price', baseBlock: 'b-model-block'}, {
        onSetMod: {
            'js': function(){
                var options = this.elem('options'),
                    _this = this,
                    uniqName = $.identify();

                this.initConsts();
                this.initModel();
                this.bindErrorEvents();

                this.model.on('reset', function(){ _this.updateDomByModel() });

                $.map(['premium', 'both'], function(el){
                    var radio = _this.elem('radio-' + el).attr('name', uniqName);

                    radio.change(function(){ _this.model.set('place', options.find('input:checked').val()) });
                    _this.elem('radio-' + el + '-label').click(function(){ radio.prop('checked', true).change() })
                });

                this.updateDomByModel();

            }
        },

        getStrategyData: function(){
            var model = this.model,
                place = model.get('place');

            model.stateData = model.memento();

            return {
                strategy: { name: 'min-price', place: place },
                description: {
                    title: this.params.title,
                    text: place == 'premium' ? iget('В спецразмещении') : iget('В спецразмещении и &laquo;гарантии&raquo;')
                }
            }
        },

        updateDomByModel: function(){
            this.model.stateData = this.model.memento();
            this.elem('radio-' + this.model.get('place').replace(/_/g, '-')).prop('checked', true);
        }

    }, {

    });
    live: true
})(jQuery);
